/*
 * Decompiled with CFR 0.152.
 */
package com.me.mygdxgame.utilities;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.Matrix4;

public class Renderer {
    private static SpriteBatch spriteBatch = null;
    private static ShapeRenderer shapeRenderer = null;
    private static boolean isBatchRendering = false;
    private static ShapeRenderer.ShapeType shapeType = ShapeRenderer.ShapeType.Filled;
    private static int CURRENT_ID = 0;
    private static int LAST_MATRIX_PUSHED_TO_BATCH = -1;
    private static int LAST_MATRIX_PUSHED_TO_SHAPE = -1;
    private Matrix4 transformMatrix = null;
    private int rendererID;

    public Renderer(Matrix4 transformMatrix) {
        this.transformMatrix = new Matrix4(transformMatrix);
        this.rendererID = CURRENT_ID++;
        if (shapeRenderer == null) {
            shapeRenderer = new ShapeRenderer();
            spriteBatch = new SpriteBatch();
            spriteBatch.begin();
            isBatchRendering = true;
        }
    }

    public static void flush() {
        if (isBatchRendering) {
            spriteBatch.flush();
        } else {
            shapeRenderer.flush();
        }
    }

    public void drawRect(ShapeRenderer.ShapeType shapeType, Color color, float x, float y, float width, float height) {
        this.prepareShapeRendererState(shapeType);
        shapeRenderer.setColor(color);
        shapeRenderer.rect(x, y, width, height);
    }

    public void drawCircle(ShapeRenderer.ShapeType shapeType, Color color, float x, float y, int radius) {
        this.prepareShapeRendererState(shapeType);
        shapeRenderer.setColor(color);
        shapeRenderer.circle(x, y, (float)radius);
    }

    public void drawSprite(Sprite sprite) {
        this.prepareSpriteBatchState();
        sprite.draw(spriteBatch);
    }

    public void drawTexture(Texture texture, float x, float y) {
        this.prepareSpriteBatchState();
        spriteBatch.draw(texture, x, y);
    }

    public void drawTexture(Texture texture, float x, float y, float width, float height) {
        this.prepareSpriteBatchState();
        spriteBatch.draw(texture, x, y, width, height);
    }

    public void drawRegion(TextureRegion region, float x, float y) {
        this.prepareSpriteBatchState();
        spriteBatch.draw(region, x, y);
    }

    public void drawRegion(TextureRegion region, float x, float y, Color tint, float scaleX, float scaleY, int rotation) {
        this.prepareSpriteBatchState();
        spriteBatch.setColor(tint);
        spriteBatch.draw(region, x, y, (float)(region.getRegionWidth() / 2), (float)(region.getRegionHeight() / 2), (float)region.getRegionWidth(), (float)region.getRegionHeight(), scaleX, scaleY, (float)rotation);
        spriteBatch.setColor(Color.WHITE);
    }

    public void drawText(BitmapFont font, CharSequence mesg, float x, float y) {
        this.prepareSpriteBatchState();
        font.draw(spriteBatch, mesg, x, y);
    }

    private void prepareShapeRendererState(ShapeRenderer.ShapeType shapeType) {
        if (isBatchRendering) {
            isBatchRendering = false;
            spriteBatch.end();
            shapeRenderer.begin(shapeType);
        } else if (Renderer.shapeType != shapeType) {
            shapeRenderer.end();
            shapeRenderer.begin(shapeType);
        }
        Renderer.shapeType = shapeType;
        if (LAST_MATRIX_PUSHED_TO_SHAPE != this.rendererID) {
            shapeRenderer.setProjectionMatrix(this.transformMatrix);
            LAST_MATRIX_PUSHED_TO_SHAPE = this.rendererID;
        }
        Gdx.gl.glEnable(3042);
        Gdx.gl.glBlendFunc(770, 771);
    }

    private void prepareSpriteBatchState() {
        if (!isBatchRendering) {
            isBatchRendering = true;
            shapeRenderer.end();
            spriteBatch.begin();
        }
        if (LAST_MATRIX_PUSHED_TO_BATCH != this.rendererID) {
            spriteBatch.setProjectionMatrix(this.transformMatrix);
            LAST_MATRIX_PUSHED_TO_BATCH = this.rendererID;
        }
    }
}

