/*
 * Decompiled with CFR 0.152.
 */
package com.me.mygdxgame.screens.seeteufelscreen;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.audio.Music;
import com.badlogic.gdx.audio.Sound;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.PerspectiveCamera;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.me.mygdxgame.cheats.BusterMaxCheat;
import com.me.mygdxgame.cheats.GeminiShotCheat;
import com.me.mygdxgame.cheats.HadoukenCheat;
import com.me.mygdxgame.cheats.JumpSpringsCheat;
import com.me.mygdxgame.cheats.KevlarOmegaArmorCheat;
import com.me.mygdxgame.entities.Door;
import com.me.mygdxgame.entities.InfinityWaterfall;
import com.me.mygdxgame.entities.MegaPlayer;
import com.me.mygdxgame.entities.Refractor;
import com.me.mygdxgame.entities.SeeteufelFront;
import com.me.mygdxgame.entities.SeeteufelSide;
import com.me.mygdxgame.entities.WatchNadia;
import com.me.mygdxgame.entities.obstacles.DamagingPlatform;
import com.me.mygdxgame.entities.obstacles.FallingPlatform;
import com.me.mygdxgame.entities.obstacles.Platform;
import com.me.mygdxgame.entities.progressbars.BonneHealthBar;
import com.me.mygdxgame.entities.progressbars.MegaHealthBar;
import com.me.mygdxgame.entities.projectiles.Rubble;
import com.me.mygdxgame.screens.seeteufelscreen.maps.FirstMap;
import com.me.mygdxgame.screens.seeteufelscreen.maps.SecondMap;
import com.me.mygdxgame.utilities.Damageable;
import com.me.mygdxgame.utilities.EntityState;
import com.me.mygdxgame.utilities.GameCheat;
import com.me.mygdxgame.utilities.GameCheatListener;
import com.me.mygdxgame.utilities.GameEntity;
import com.me.mygdxgame.utilities.GameScreen;
import com.me.mygdxgame.utilities.GameState;
import com.me.mygdxgame.utilities.GenericDamager;
import com.me.mygdxgame.utilities.GenericEntity;
import com.me.mygdxgame.utilities.Renderer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;

public class SeeteufelScreen
implements GameScreen {
    private static final int SCREEN_TOP = 188;
    private static final int SCREEN_BOTTOM = -188;
    private static final int SCREEN_LEFT = -350;
    private static final int ENEMY_HEALTHBAR_MOVE_SPEED = 40;
    private static final Vector2 PLAYER_HEALTH_POS = new Vector2(-340.0f, -178.0f);
    private static final int ENEMY_HEALTH_TARGET_X = (int)SeeteufelScreen.PLAYER_HEALTH_POS.x;
    private static final int MAP1_CAM_Y = -37;
    private static final float MAP2_CAM_SPEED_1 = 25.0f;
    private static final float MAP2_CAM_SPEED_2 = 35.0f;
    private static final float MAP2_CAM_X = 320.0f;
    private static final Vector3 MAP2_SEETEUFEL_INIT_POS = new Vector3(320.0f, 768.0f, 0.0f);
    private static final Color WATER_COLOR = new Color(0.5f, 0.5f, 1.0f, 0.5f);
    private static final int MAP2_HEIGHT = 48;
    private static final int MAP2_PIXEL_HEIGHT = 1536;
    private static final int MAP2_ACTIVATION_X = 480;
    private static final float MAP2_CAM_MAX_Y = 1536.0f;
    private static final float MAP2_CAM_INCREASE_SPEED_TIRGGER_Y = 768.0f;
    private static final int MAP2_ENEMY_ATTACK_OFFSET = 128;
    private static final int MAP2_PLAYER_DROWN_OFFSET = 64;
    private static final float MAP2_INITIAL_CAM_Y = 188.0f;
    private static final float MAP2_WATER_Y_OFFSET = 75.0f;
    private static final int MAP2_WATERFALL_OFFSET = 200;
    private static final int CAMERA_SHAKE = 15;
    private static final float CAMERA_SHAKE_FALLOFF = 0.5f;
    private static final float MAP2_STAIR_STEP_HEIGHT = 0.5f;
    private static final float MAP2_STAIR_FLIGHT_HEIGHT = 4.5f;
    private static final int MAP2_STAIR_FLIGHT_X_OFFSET = 5;
    private static final int MAP2_STAIR_STEP_LENGTH = 3;
    private static final int MAP2_STAIR_IGNORE_LAST_TARGETS = 2;
    private static final int MAP2_WATER_LATENT_RISE_RATE = 90;
    private static final int MAP2_WATER_WIDTH = 640;
    private static final int MAP3_WATER_BASE_X = 1036;
    private static final int MAP3_CAM_Y = 1700;
    private static final float MAP3_CAM_MIN_X = -2.0f;
    private static final float MAP3_CAM_MAX_X = 322.0f;
    private static final float SFX_VOLUME = 0.5f;
    private static final float MAP2_PLATFORM_DESTRUCTION_DELAY = 0.3f;
    private static final String WIN_MESSAGE = "Thank you for playing!";
    private static final int PAUSE_KEY = 59;
    private static final int FPS_KEY = 73;
    private GameState state = GameState.Running;
    private FirstMap map1;
    private SecondMap map2;
    private int currentMap;
    private Texture t_tiles1;
    private Texture waterfall;
    private BitmapFont font;
    private MegaPlayer.MegaPlayerResources playerResources = new MegaPlayer.MegaPlayerResources();
    private MapTiles mapTiles = new MapTiles();
    private Sound explosion;
    private Sound splash;
    private Sound seeSplash;
    private Sound bombShoot;
    private Sound doorOpen;
    private Sound doorClose;
    private Sound itemGet;
    private Sound enemyDamage;
    private Music music1;
    private Music music2;
    private LinkedList<GameEntity> entities = new LinkedList();
    private LinkedList<GameEntity> toRemove = new LinkedList();
    private LinkedList<GameEntity[]> toAdd = new LinkedList();
    private MegaPlayer player;
    private MegaHealthBar playerHealth;
    private BonneHealthBar enemyHealth;
    private Refractor refractor;
    private Door room1Exit;
    private Door room2Entrance;
    private Door room3Exit;
    private WatchNadia bonus;
    private SeeteufelFront seeFront;
    private SeeteufelSide seeSide;
    private Renderer hudRenderer;
    private InfinityWaterfall room2Fall1;
    private InfinityWaterfall room2Fall2;
    private TextureRegion missionComplete;
    private LinkedList<GameEntity> obstacles = new LinkedList();
    private LinkedList<FallingPlatform> fallingBlocks = new LinkedList();
    private LinkedList<FallingPlatform> fallenBlocks = new LinkedList();
    private Collection<Damageable> ceilingTargets = new LinkedList<Damageable>();
    private LinkedList<Damageable> playerTargets = new LinkedList();
    private LinkedList<LinkedList<Damageable>> seeteufelTargets = new LinkedList();
    private LinkedList<LinkedList<Damageable>> removedSeeteufelTargets = new LinkedList();
    private LinkedList<Damageable> room2InitialStairs = new LinkedList();
    private LinkedList<Damageable> room2NonTargettedStairs = new LinkedList();
    private LinkedList<Integer> seeteufelTargetLevels = new LinkedList();
    private Rectangle map2Ceiling = null;
    private Rectangle visibleRegion = new Rectangle();
    private LinkedList<Damageable> room2PlatformsToDestroy = new LinkedList();
    private boolean isMap2Flooding = false;
    private boolean displayFps = false;
    private boolean displayFpsButtonTrigger = false;
    private boolean firstWaterfallFell = false;
    private boolean secondWaterfallFell = false;
    private boolean isPaused = false;
    private boolean pauseButtonTrigger = false;
    private boolean bypassedSeeteufel = false;
    private boolean reachedArenaBeforeCamera = false;
    private boolean isMusicPaused = false;
    private Music currentMusic = null;
    private float map2Y = 188.0f;
    private float map2WaterY = 113.0f;
    private float cameraShake = 0.0f;
    private Vector2 map3CamPos = new Vector2();
    private float map2PlatformDestuctionTimer = 0.0f;
    private float map3ExitBridgeFallTimer = 0.0f;
    private GameCheatListener cheatEngine;
    private InputProcessor defaultProcessor;
    private GameCheat unlockedCheat;

    public SeeteufelScreen() {
        this.hudRenderer = new Renderer(new OrthographicCamera((float)((float)Gdx.graphics.getWidth()), (float)((float)Gdx.graphics.getHeight())).combined);
    }

    @Override
    public void load() {
        this.mapTiles.load();
        this.t_tiles1 = new Texture("img/seeteufelScreen.png");
        this.waterfall = new Texture("img/waterfall1.png");
        this.waterfall.setWrap(Texture.TextureWrap.Repeat, Texture.TextureWrap.Repeat);
        this.waterfall.setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
        this.playerResources.load();
        this.explosion = Gdx.audio.newSound(Gdx.files.internal("sound/sfx-grenade-explode1.ogg"));
        this.splash = Gdx.audio.newSound(Gdx.files.internal("sound/splash.ogg"));
        this.seeSplash = Gdx.audio.newSound(Gdx.files.internal("sound/see_crash.ogg"));
        this.bombShoot = Gdx.audio.newSound(Gdx.files.internal("sound/bomb_fire.ogg"));
        this.music1 = Gdx.audio.newMusic(Gdx.files.internal("sound/Seeteufel_the_Mighty_intro.ogg"));
        this.music2 = Gdx.audio.newMusic(Gdx.files.internal("sound/Seeteufel_the_Mighty_loop.ogg"));
        this.doorOpen = Gdx.audio.newSound(Gdx.files.internal("sound/sfx-ruindoor-open1.ogg"));
        this.doorClose = Gdx.audio.newSound(Gdx.files.internal("sound/sfx-ruindoor-close1.ogg"));
        this.itemGet = Gdx.audio.newSound(Gdx.files.internal("sound/sfx-item-get.ogg"));
        this.enemyDamage = Gdx.audio.newSound(Gdx.files.internal("sound/sfx-reaverhurt1.ogg"));
        this.font = new BitmapFont(Gdx.files.internal("data/emulogic.fnt"), Gdx.files.internal("data/emulogic.png"), false);
        this.playerResources.footstepSound.play();
        this.playerResources.footstepSound.stop();
        this.playerResources.hurtSound.play();
        this.playerResources.hurtSound.stop();
        this.playerResources.jumpSound.play();
        this.playerResources.jumpSound.stop();
        this.playerResources.landSound.play();
        this.playerResources.landSound.stop();
        this.playerResources.shootSound.play();
        this.playerResources.shootSound.stop();
        this.playerResources.shotMissSound.play();
        this.playerResources.shotMissSound.stop();
        this.explosion.play();
        this.explosion.stop();
        this.splash.play();
        this.splash.stop();
        this.seeSplash.play();
        this.seeSplash.stop();
        this.bombShoot.play();
        this.bombShoot.stop();
        this.doorOpen.play();
        this.doorOpen.stop();
        this.doorClose.play();
        this.doorClose.stop();
        this.music1.play();
        this.music1.stop();
        this.music2.play();
        this.music2.stop();
        this.enemyDamage.play();
        this.enemyDamage.stop();
        this.map1 = new FirstMap(this.t_tiles1, this.mapTiles);
        this.map2 = new SecondMap(this.t_tiles1, this.mapTiles, 48);
        this.currentMap = 1;
    }

    @Override
    public void unload() {
        this.mapTiles.unload();
        this.t_tiles1.dispose();
        this.waterfall.dispose();
        this.playerResources.unload();
        this.explosion.dispose();
        this.explosion.dispose();
        this.splash.dispose();
        this.seeSplash.dispose();
        this.bombShoot.dispose();
        this.music1.dispose();
        this.music2.dispose();
        this.doorOpen.dispose();
        this.doorClose.dispose();
        this.itemGet.dispose();
        this.font.dispose();
        this.enemyDamage.dispose();
    }

    @Override
    public void render(float deltaTime, int difficulty, PerspectiveCamera perspCam, OrthographicCamera orthoCam) {
        if (!Gdx.input.isKeyPressed(59)) {
            this.pauseButtonTrigger = true;
        }
        if (this.pauseButtonTrigger && Gdx.input.isKeyPressed(59)) {
            this.isPaused = !this.isPaused;
            this.pauseButtonTrigger = false;
            if (this.isPaused) {
                Gdx.input.setInputProcessor((InputProcessor)this.cheatEngine);
                if (this.currentMusic.isPlaying()) {
                    this.currentMusic.pause();
                    this.isMusicPaused = true;
                }
            } else {
                Gdx.input.setInputProcessor(this.defaultProcessor);
                if (this.isMusicPaused) {
                    this.currentMusic.play();
                    this.isMusicPaused = false;
                }
            }
        }
        if (!Gdx.input.isKeyPressed(73)) {
            this.displayFpsButtonTrigger = true;
        }
        if (this.displayFpsButtonTrigger && Gdx.input.isKeyPressed(73)) {
            this.displayFps = !this.displayFps;
            this.displayFpsButtonTrigger = false;
        }
        Gdx.gl.glClear(16640);
        if (this.currentMap == 1) {
            if (this.isPaused) {
                this.renderMap1(0.0f, perspCam, orthoCam);
            } else {
                this.renderMap1(deltaTime, perspCam, orthoCam);
                this.updateMap1(deltaTime, difficulty);
            }
        } else if (this.currentMap == 2) {
            if (this.isPaused) {
                this.renderMap2(0.0f, perspCam, orthoCam);
            } else {
                this.renderMap2(deltaTime, perspCam, orthoCam);
                this.updateMap2(deltaTime, difficulty);
            }
        } else if (this.currentMap == 3) {
            if (this.isPaused) {
                this.renderMap3(0.0f, perspCam, orthoCam);
            } else {
                this.renderMap3(deltaTime, perspCam, orthoCam);
                this.updateMap3(deltaTime, difficulty);
            }
        } else if (this.isPaused) {
            this.renderMap4(0.0f, perspCam, orthoCam);
        } else {
            this.renderMap4(deltaTime, perspCam, orthoCam);
            this.updateMap4(deltaTime, difficulty);
        }
        int halfWidth = Gdx.graphics.getWidth() / 2;
        int halfHeight = Gdx.graphics.getHeight() / 2;
        int cheatTextX = -halfWidth;
        int cheatTextY = halfHeight;
        float cheatTextHeight = this.font.getBounds((CharSequence)"TEST").height;
        if (this.isPaused) {
            this.music1.pause();
            this.music2.pause();
            this.hudRenderer.drawRect(ShapeRenderer.ShapeType.Filled, new Color(0.0f, 0.0f, 0.0f, 0.5f), -halfWidth, -halfHeight, Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
        }
        if (this.displayFps) {
            this.font.setScale(1.0f, 1.0f);
            String fpsString = Integer.toString(Gdx.graphics.getFramesPerSecond());
            this.hudRenderer.drawText(this.font, fpsString, cheatTextX, cheatTextY);
            cheatTextY = (int)((float)cheatTextY - cheatTextHeight);
        }
        if (this.isPaused) {
            for (GameCheat cheat : this.cheatEngine.getAllCheats()) {
                if (!cheat.isEnabled()) continue;
                this.hudRenderer.drawText(this.font, cheat.getDescription(), cheatTextX, cheatTextY);
                cheatTextY = (int)((float)cheatTextY - cheatTextHeight);
            }
            this.font.setScale(1.5f, 1.5f);
            int pauseOffsetX = (int)(this.font.getBounds((CharSequence)"Paused").width / 2.0f);
            int pauseOffsetY = (int)(this.font.getBounds((CharSequence)"Paused").height / 2.0f);
            this.hudRenderer.drawText(this.font, "Paused", -pauseOffsetX, -pauseOffsetY);
        }
        this.font.setScale(1.0f, 1.0f);
        Renderer.flush();
        if (this.player.getState() == EntityState.Destroyed) {
            this.state = GameState.Lose;
            this.music1.stop();
            this.music2.stop();
        }
    }

    @Override
    public void initialize() {
        this.currentMap = 1;
        this.obstacles.clear();
        this.playerTargets.clear();
        this.seeteufelTargets.clear();
        this.room2PlatformsToDestroy.clear();
        this.isMap2Flooding = false;
        this.firstWaterfallFell = false;
        this.secondWaterfallFell = false;
        this.state = GameState.Running;
        this.map2Y = 188.0f;
        this.map2WaterY = 113.0f;
        this.seeteufelTargets.clear();
        this.seeteufelTargetLevels.clear();
        this.removedSeeteufelTargets.clear();
        this.room2InitialStairs.clear();
        this.room2NonTargettedStairs.clear();
        this.cameraShake = 0.0f;
        this.map2PlatformDestuctionTimer = 0.0f;
        this.map3ExitBridgeFallTimer = 0.0f;
        this.music1.stop();
        this.music2.stop();
        this.seeFront = null;
        this.music1.setOnCompletionListener(new Music.OnCompletionListener(){

            public void onCompletion(Music music) {
                SeeteufelScreen.this.music2.play();
                SeeteufelScreen.this.music2.setLooping(true);
                SeeteufelScreen.this.currentMusic = SeeteufelScreen.this.music2;
            }
        });
        this.currentMusic = this.music1;
        this.isMusicPaused = false;
        for (GameEntity e : this.entities) {
            e.destroy();
        }
        this.entities.clear();
        this.player = new MegaPlayer(this.t_tiles1, this.playerResources, this.map1.getInitialPosition(), Collections.unmodifiableCollection(this.obstacles), Collections.unmodifiableCollection(this.playerTargets));
        this.playerHealth = new MegaHealthBar(this.t_tiles1, (int)SeeteufelScreen.PLAYER_HEALTH_POS.x, (int)SeeteufelScreen.PLAYER_HEALTH_POS.y);
        this.enemyHealth = new BonneHealthBar(this.t_tiles1, 0, 0);
        this.refractor = new Refractor(this.t_tiles1, this.itemGet, this.font, (int)Math.ceil(-87.0), (int)Math.ceil(-70.0));
        this.room1Exit = new Door(this.t_tiles1, this.doorOpen, this.doorClose, 434, -156);
        this.cheatEngine = new GameCheatListener(10, this.itemGet);
        this.defaultProcessor = this.player.getComboListener();
        this.cheatEngine.addCheat(new BusterMaxCheat(this.player));
        this.cheatEngine.addCheat(new JumpSpringsCheat(this.player));
        this.cheatEngine.addCheat(new GeminiShotCheat(this.player));
        this.cheatEngine.addCheat(new KevlarOmegaArmorCheat(this.player));
        this.cheatEngine.addCheat(new HadoukenCheat(this.player));
        this.entities.add(this.refractor);
        this.entities.add(this.room1Exit);
        this.obstacles.add(this.map1.getObstacles());
        this.bypassedSeeteufel = false;
        this.reachedArenaBeforeCamera = false;
    }

    @Override
    public GameState getState() {
        return this.state;
    }

    private void updateMap1(float deltaTime, int difficulty) {
        for (GameEntity e : this.entities) {
            e.update(deltaTime);
            if (e.getState() == EntityState.Destroyed) {
                this.toRemove.addFirst(e);
            }
            if (!e.hasCreatedEntities()) continue;
            this.toAdd.addFirst(e.getCreatedEntities());
        }
        this.map1.update(deltaTime);
        this.player.update(deltaTime);
        if (this.player.hasCreatedEntities()) {
            this.toAdd.addFirst(this.player.getCreatedEntities());
        }
        this.playerHealth.setInDanger(false);
        this.playerHealth.setValue((float)this.player.getHealth() / (float)this.player.getMaxHealth());
        this.playerHealth.draw(this.hudRenderer);
        this.entities.removeAll(this.toRemove);
        Iterator iterator = this.toAdd.iterator();
        while (iterator.hasNext()) {
            GameEntity[] newEntities;
            GameEntity[] gameEntityArray = newEntities = (GameEntity[])iterator.next();
            int n = newEntities.length;
            int n2 = 0;
            while (n2 < n) {
                GameEntity e = gameEntityArray[n2];
                this.entities.add(e);
                ++n2;
            }
        }
        this.toAdd.clear();
        this.toRemove.clear();
        Rectangle[] rectangleArray = this.player.getHitArea();
        int n = rectangleArray.length;
        int n3 = 0;
        while (n3 < n) {
            Rectangle box = rectangleArray[n3];
            if (this.refractor.getHitArea()[0].overlaps(box)) {
                this.refractor.onTake();
            }
            if (this.room1Exit.getDoorState() == Door.DoorState.OPEN && this.room1Exit.getHitBox().overlaps(box) && (Gdx.input.isKeyPressed(20) || Gdx.input.isKeyPressed(47))) {
                this.currentMap = 2;
                this.setupMap2();
            }
            ++n3;
        }
        if (this.refractor.getState() == EntityState.Destroyed && this.room1Exit.getDoorState() == Door.DoorState.SHUT) {
            this.room1Exit.setIsOpen(Door.DoorState.OPEN, true);
        }
    }

    private void renderMap1(float deltaTime, PerspectiveCamera perspCam, OrthographicCamera orthoCam) {
        orthoCam.position.x = this.player.getPosition().x;
        float halfWidth = 350.0f;
        float minVisibleX = orthoCam.position.x - halfWidth;
        float minVisibleY = orthoCam.position.y - 188.0f;
        float maxVisibleX = orthoCam.position.x + halfWidth;
        if (minVisibleX <= -382.0f) {
            orthoCam.position.x = -382.0f + halfWidth;
        } else if (maxVisibleX >= 514.0f) {
            orthoCam.position.x = 514.0f - halfWidth;
        }
        orthoCam.position.y = -37.0f;
        orthoCam.update();
        Renderer renderer = new Renderer(orthoCam.combined);
        this.visibleRegion.set(minVisibleX, minVisibleY, 700.0f, 376.0f);
        this.map1.render(deltaTime, this.visibleRegion, renderer);
        for (GameEntity e : this.entities) {
            e.draw(renderer);
        }
        this.player.draw(renderer);
        this.playerHealth.draw(this.hudRenderer);
    }

    private void setupMap2() {
        for (GameEntity e : this.entities) {
            e.destroy();
        }
        this.entities.clear();
        this.playerTargets.clear();
        this.seeteufelTargets.clear();
        this.obstacles.clear();
        this.obstacles.add(this.map2.getObstacles());
        this.generateMap2Stairs();
        this.bonus = this.makeBonusTile();
        this.entities.add(this.bonus);
        this.playerTargets.add(this.bonus);
        this.map2Ceiling = new Rectangle(0.0f, 0.0f, (float)Gdx.graphics.getWidth(), 50.0f);
        this.obstacles.add(new GenericEntity(Arrays.asList(this.map2Ceiling)));
        Vector3 map2InitPos = this.map2.getInitialPosition();
        this.player.setPosition(map2InitPos);
        this.room2Entrance = new Door(this.t_tiles1, this.doorOpen, this.doorClose, 32, 128);
        this.room2Entrance.setIsOpen(Door.DoorState.SHUT, false);
        this.room3Exit = new Door(this.t_tiles1, this.doorOpen, this.doorClose, 576 - this.room2Entrance.getWidth() / 2, 1568);
        this.room3Exit.setIsOpen(Door.DoorState.OPEN, false);
        this.entities.add(this.room2Entrance);
        this.entities.add(this.room3Exit);
        this.room2Fall1 = new InfinityWaterfall(this.waterfall, this.t_tiles1, 100, 1736, 1);
        this.room2Fall2 = new InfinityWaterfall(this.waterfall, this.t_tiles1, 510, 1736, 1);
    }

    private void generateMap2Stairs() {
        int currentTileX = 10;
        int currentTileY = 2;
        int maxTileX = 19;
        Platform destructableTile = null;
        currentTileX = 10;
        while (currentTileX < maxTileX) {
            destructableTile = new Platform(this.t_tiles1, this.mapTiles, currentTileX * 32, (int)((float)(currentTileY * 32) * 0.5f));
            this.obstacles.add(destructableTile);
            this.entities.add(destructableTile);
            this.room2InitialStairs.add(destructableTile);
            if (currentTileX % 3 == 0) {
                ++currentTileY;
            }
            ++currentTileX;
        }
        boolean platformDirection = false;
        currentTileX -= 5;
        currentTileY = (int)((float)currentTileY + 4.5f);
        this.seeteufelTargets.addFirst(new LinkedList());
        this.seeteufelTargetLevels.addFirst(currentTileY * 16);
        while ((float)currentTileY * 0.5f < 48.0f) {
            int currentYCoord = (int)((float)currentTileY * 16.0f);
            destructableTile = new Platform(this.t_tiles1, this.mapTiles, currentTileX * 32, currentYCoord);
            this.seeteufelTargets.peek().add(destructableTile);
            if (platformDirection) {
                if (++currentTileX == maxTileX) {
                    currentTileX = currentTileX % 3 == 0 ? (currentTileX -= 6) : (currentTileX -= 5);
                    currentTileY = (int)((float)currentTileY + 4.5f);
                    platformDirection = !platformDirection;
                    this.seeteufelTargets.addFirst(new LinkedList());
                    this.seeteufelTargetLevels.addFirst(currentYCoord);
                    continue;
                }
                if (currentTileX % 3 != 0) continue;
                ++currentTileY;
                continue;
            }
            if (--currentTileX == 0) {
                currentTileX = currentTileX % 3 == 0 ? (currentTileX += 6) : (currentTileX += 5);
                currentTileY = (int)((float)currentTileY + 4.5f);
                platformDirection = !platformDirection;
                this.seeteufelTargets.addFirst(new LinkedList());
                this.seeteufelTargetLevels.addFirst(currentYCoord);
                continue;
            }
            if (currentTileX % 3 != 0) continue;
            ++currentTileY;
        }
        LinkedList<Damageable> removedList = this.seeteufelTargets.removeLast();
        this.obstacles.addAll(removedList);
        this.entities.addAll(removedList);
        this.room2NonTargettedStairs.addAll(removedList);
        removedList = this.seeteufelTargets.removeLast();
        this.obstacles.addAll(removedList);
        this.entities.addAll(removedList);
        this.room2NonTargettedStairs.addAll(removedList);
        this.seeteufelTargetLevels.removeLast();
        this.seeteufelTargetLevels.removeLast();
        this.seeteufelTargets.removeFirst();
        this.seeteufelTargetLevels.removeFirst();
        this.seeteufelTargetLevels.removeFirst();
        removedList = this.seeteufelTargets.getLast();
        this.obstacles.addAll(removedList);
        this.entities.addAll(removedList);
    }

    private int[] getSeeteufelTargets(Damageable[] currentTargets, boolean isUpperArea) {
        int[] targets = null;
        targets = isUpperArea ? new int[4] : new int[3];
        targets[0] = Math.max(1, (int)(Math.random() * (double)currentTargets.length - 2.0));
        do {
            targets[1] = Math.max(1, (int)(Math.random() * (double)currentTargets.length - 2.0));
        } while (targets[1] == targets[0] || targets[0] == 8 && targets[1] == 9 || targets[0] == 9 && targets[1] == 8);
        do {
            targets[2] = Math.max(1, (int)(Math.random() * (double)currentTargets.length - 2.0));
        } while (targets[2] == targets[1] || targets[2] == targets[0] || Math.abs(targets[2] - targets[0]) == 1 || Math.abs(targets[2] - targets[1]) == 1);
        if (isUpperArea) {
            do {
                targets[3] = Math.max(1, (int)(Math.random() * (double)currentTargets.length - 2.0));
            } while (targets[3] == targets[0] || targets[3] == targets[1] || targets[3] == targets[2] || Math.abs(targets[3] - targets[0]) == 1 || Math.abs(targets[3] - targets[1]) == 1 || Math.abs(targets[3] - targets[2]) == 1);
        }
        return targets;
    }

    private WatchNadia makeBonusTile() {
        int bonusYOffset = (int)(System.currentTimeMillis() % 5L) + 4;
        boolean leftSide = bonusYOffset % 2 == 0;
        int bonusX = leftSide ? 0 : 608;
        int bonusY = 9 + (int)(4.5f * (float)bonusYOffset * 32.0f);
        bonusY -= bonusY % 32;
        WatchNadia seriouslyWtfMlt = new WatchNadia(this.mapTiles.bonusTex, this.player, this.itemGet, 0.5f, bonusX, bonusY);
        return seriouslyWtfMlt;
    }

    private void updateMap2(float deltaTime, int difficulty) {
        Vector3 playerPos = this.player.getPosition();
        int targetWaterfalHeight = 1536 - (int)this.map2WaterY + 200;
        if (this.isMap2Flooding) {
            if (this.firstWaterfallFell) {
                if (this.map2Y < 1536.0f) {
                    float movement;
                    if (this.map2Y > 768.0f && this.secondWaterfallFell) {
                        movement = 35.0f * deltaTime;
                        this.map2Y += movement;
                    } else {
                        movement = 25.0f * deltaTime;
                        this.map2Y += movement;
                    }
                    this.map2WaterY = this.map2Y - 75.0f;
                } else if (this.map2WaterY < 1536.0f) {
                    this.map2WaterY += 90.0f * deltaTime;
                    if (this.map2WaterY > 1536.0f) {
                        this.map2WaterY = 1536.0f;
                    }
                }
            }
        } else if (playerPos.x > 480.0f) {
            this.isMap2Flooding = true;
            this.music1.play();
            this.currentMusic = this.music1;
            this.seeSplash.play(0.5f);
            this.cameraShake = 15.0f;
            this.playerHealth.setInDanger(true);
            this.seeFront = new SeeteufelFront(this.t_tiles1, this.t_tiles1, this.explosion, this.seeSplash, this.bombShoot, MAP2_SEETEUFEL_INIT_POS);
        }
        this.map2.update(deltaTime);
        float screenTop = this.map2Y + (float)(Gdx.graphics.getHeight() / 2);
        this.map2Ceiling.setPosition(0.0f, screenTop);
        if (this.isMap2Flooding) {
            if (this.firstWaterfallFell) {
                this.room2Fall1.setHeight(targetWaterfalHeight);
            } else {
                this.room2Fall1.setHeight((int)((float)this.room2Fall1.getHeight() + 750.0f * deltaTime));
                if (this.room2Fall1.getHeight() >= targetWaterfalHeight) {
                    this.firstWaterfallFell = true;
                    this.room2Fall1.setHeight(targetWaterfalHeight);
                }
            }
            if (this.secondWaterfallFell) {
                this.room2Fall2.setHeight(targetWaterfalHeight);
            } else if (this.map2Y > 768.0f) {
                this.room2Fall2.setHeight((int)((float)this.room2Fall2.getHeight() + 750.0f * deltaTime));
                if (this.room2Fall2.getHeight() >= targetWaterfalHeight) {
                    this.secondWaterfallFell = true;
                    this.room2Fall2.setHeight(targetWaterfalHeight);
                }
            }
            this.room2Fall1.update(deltaTime);
            this.room2Fall2.update(deltaTime);
            this.seeFront.setTargetY((int)this.map2WaterY);
            this.seeFront.update(deltaTime);
            if (!this.seeteufelTargetLevels.isEmpty()) {
                Integer currentLevel = this.seeteufelTargetLevels.removeLast();
                if (this.map2WaterY >= (float)(currentLevel - 128)) {
                    LinkedList<Damageable> currentTargetList = this.seeteufelTargets.removeLast();
                    Damageable[] currentTargets = new Damageable[currentTargetList.size()];
                    currentTargets = currentTargetList.toArray(currentTargets);
                    int[] targets = this.getSeeteufelTargets(currentTargets, this.secondWaterfallFell);
                    LinkedList<Damageable> removedList = null;
                    this.removedSeeteufelTargets.add(currentTargetList);
                    if (this.removedSeeteufelTargets.size() > 2) {
                        removedList = this.removedSeeteufelTargets.removeFirst();
                        this.room2PlatformsToDestroy.addAll(removedList);
                        if (!this.room2NonTargettedStairs.isEmpty()) {
                            GenericDamager damager = new GenericDamager(1, 0);
                            for (Damageable platform : this.room2NonTargettedStairs) {
                                platform.damage(damager);
                            }
                            this.room2NonTargettedStairs.clear();
                            this.explosion.stop();
                            this.explosion.play();
                        }
                    }
                    if (!this.seeteufelTargets.isEmpty()) {
                        removedList = this.seeteufelTargets.getLast();
                        this.obstacles.addAll(removedList);
                        this.entities.addAll(removedList);
                    }
                    int[] nArray = targets;
                    int n = targets.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int x = nArray[n2];
                        this.seeFront.attack(currentTargets[x]);
                        ++n2;
                    }
                    if (this.seeteufelTargetLevels.isEmpty()) {
                        while (!this.removedSeeteufelTargets.isEmpty()) {
                            this.room2PlatformsToDestroy.addAll((Collection<Damageable>)this.removedSeeteufelTargets.removeFirst());
                        }
                        while (!this.seeteufelTargets.isEmpty()) {
                            this.room2PlatformsToDestroy.addAll((Collection<Damageable>)this.seeteufelTargets.removeFirst());
                        }
                    }
                } else {
                    this.seeteufelTargetLevels.addLast(currentLevel);
                }
            }
            if (this.seeFront.hasCreatedEntities()) {
                GameEntity[] newEntities;
                GameEntity[] gameEntityArray = newEntities = this.seeFront.getCreatedEntities();
                int n = newEntities.length;
                int n3 = 0;
                while (n3 < n) {
                    GameEntity entity = gameEntityArray[n3];
                    this.entities.addLast(entity);
                    ++n3;
                }
            }
        }
        for (GameEntity e : this.entities) {
            e.update(deltaTime);
            if (e instanceof Rubble) {
                ((Rubble)e).setWaterLevel(this.map2WaterY, this.splash);
            }
            if (e.getState() == EntityState.Destroyed) {
                this.toRemove.addFirst(e);
            }
            if (!e.hasCreatedEntities()) continue;
            this.toAdd.addFirst(e.getCreatedEntities());
        }
        if (!this.room2PlatformsToDestroy.isEmpty()) {
            this.map2PlatformDestuctionTimer += deltaTime;
            if (this.map2PlatformDestuctionTimer >= 0.3f) {
                Damageable target = this.room2PlatformsToDestroy.removeFirst();
                while (!this.room2PlatformsToDestroy.isEmpty() && target.getState() == EntityState.Destroyed) {
                    target = this.room2PlatformsToDestroy.removeFirst();
                }
                target.damage(new GenericDamager(1, 0));
                this.map2PlatformDestuctionTimer = 0.0f;
                this.explosion.stop();
                this.explosion.play();
            }
        }
        if (playerPos.y + 64.0f < this.map2Y - (float)(Gdx.graphics.getHeight() / 2)) {
            this.player.destroy();
        }
        if (playerPos.y < this.map2WaterY) {
            if (!this.player.getIsUnderwater()) {
                this.splash.play(0.5f);
                this.player.setIsUnderwater(true, true);
            }
        } else if (this.player.getIsUnderwater()) {
            this.player.setIsUnderwater(false, false);
        }
        this.player.update(deltaTime);
        if (this.player.hasCreatedEntities()) {
            this.toAdd.addFirst(this.player.getCreatedEntities());
        }
        this.playerHealth.setValue((float)this.player.getHealth() / (float)this.player.getMaxHealth());
        if (!this.player.getIsInAir() && (double)playerPos.y >= 1552.0 && playerPos.x <= 32.0f) {
            this.currentMap = 3;
            this.setupMap3();
            if (this.seeteufelTargetLevels.isEmpty() && this.room2PlatformsToDestroy.size() >= 15) {
                this.reachedArenaBeforeCamera = true;
            }
        }
        this.entities.removeAll(this.toRemove);
        for (GameEntity e : this.toRemove) {
            if (!(e instanceof Platform)) continue;
            this.obstacles.remove(e);
        }
        for (GameEntity[] newEntities : this.toAdd) {
            this.entities.addAll(Arrays.asList(newEntities));
        }
        this.toAdd.clear();
        this.toRemove.clear();
        if (!this.player.getIsInAir() && this.player.getHitArea()[0].overlaps(this.room3Exit.getHitArea()[0]) && (Gdx.input.isKeyPressed(20) || Gdx.input.isKeyPressed(47))) {
            this.bypassedSeeteufel = true;
            this.setupMap4();
            this.currentMap = 4;
        }
    }

    private void renderMap2(float deltaTime, PerspectiveCamera perspCam, OrthographicCamera orthoCam) {
        orthoCam.position.x = 320.0f;
        orthoCam.position.y = (float)Math.floor(this.map2Y + this.cameraShake);
        orthoCam.update();
        if (this.cameraShake > 0.0f) {
            this.cameraShake = -this.cameraShake + 0.5f;
        } else if (this.cameraShake < 0.0f) {
            this.cameraShake = -this.cameraShake - 0.5f;
        }
        Renderer renderer = new Renderer(orthoCam.combined);
        float minVisibleX = orthoCam.position.x - 350.0f;
        float minVisibleY = orthoCam.position.y - 188.0f;
        this.visibleRegion.set(minVisibleX, minVisibleY, 700.0f, 376.0f);
        this.map2.render(deltaTime, this.visibleRegion, renderer);
        this.room2Fall1.draw(renderer);
        this.room2Fall2.draw(renderer);
        if (this.seeFront != null) {
            this.seeFront.draw(renderer);
        }
        float entityY = 0.0f;
        float screenBottom = orthoCam.position.y - (float)(Gdx.graphics.getHeight() / 2) - 56.0f;
        float screenTop = orthoCam.position.y + (float)(Gdx.graphics.getHeight() / 2);
        for (GameEntity e : this.entities) {
            entityY = e.getPosition().y;
            if (!(entityY < screenTop) || !(entityY > screenBottom)) continue;
            e.draw(renderer);
        }
        this.player.draw(renderer);
        renderer.drawRect(ShapeRenderer.ShapeType.Filled, WATER_COLOR, 0.0f, 0.0f, 640.0f, this.map2WaterY);
        this.playerHealth.draw(this.hudRenderer);
    }

    private void setupMap3() {
        this.map3CamPos.x = 320.0f;
        this.map3CamPos.y = this.map2Y;
        this.obstacles.clear();
        this.obstacles.add(this.map2.getObstacles());
        GenericDamager damager = new GenericDamager(1, 0);
        for (GameEntity entity : this.entities) {
            if (!(entity instanceof Platform)) continue;
            ((Platform)entity).damage(damager);
        }
        this.explosion.play(0.5f);
        int enemyHealthY = 188 - this.enemyHealth.getHeight() - 10;
        this.enemyHealth.setPosition(-1350, enemyHealthY);
        this.seeteufelTargets.clear();
        this.seeteufelTargets.offer(new LinkedList());
        this.seeteufelTargets.get(0).add(this.player);
        this.ceilingTargets.clear();
        int x = 0;
        while (x < 10) {
            this.ceilingTargets.add(new DamagingPlatform(this.t_tiles1, this.mapTiles, -x * 32, 1824, (Collection<Damageable>)this.seeteufelTargets.get(0)));
            ++x;
        }
        Vector3 seeSideStartPos = new Vector3(MAP2_SEETEUFEL_INIT_POS);
        seeSideStartPos.y = this.seeFront.getTargetY();
        this.seeSide = new SeeteufelSide(this.t_tiles1, this.explosion, this.bombShoot, this.enemyDamage, this.playerResources, seeSideStartPos, (Collection<Damageable>)this.seeteufelTargets.get(0), this.obstacles, this.ceilingTargets);
        this.playerTargets.add(this.seeSide);
        this.fallingBlocks.clear();
        this.fallenBlocks.clear();
        int fallingBlockY = 1824;
        int fallingBlockTargetY = 1536;
        int x2 = 1;
        while (x2 < 17) {
            this.fallingBlocks.add(new FallingPlatform(this.t_tiles1, this.mapTiles, this.seeSplash, x2 * 32, fallingBlockY, fallingBlockTargetY));
            this.obstacles.add(this.fallingBlocks.getLast());
            ++x2;
        }
    }

    private void updateMap3(float deltaTime, int difficulty) {
        Vector3 playerPos = this.player.getPosition();
        if (this.map3CamPos.x > playerPos.x) {
            this.map3CamPos.x -= Math.min(250.0f * deltaTime, this.map3CamPos.x - playerPos.x);
        } else if (this.map3CamPos.x < playerPos.x) {
            this.map3CamPos.x += Math.min(250.0f * deltaTime, playerPos.x - this.map3CamPos.x);
        }
        if (this.map3CamPos.y < 1700.0f) {
            this.map3CamPos.y += Math.min(250.0f * deltaTime, 1700.0f - this.map3CamPos.y);
        }
        if (this.map3CamPos.x < -2.0f) {
            this.map3CamPos.x = -2.0f;
        } else if (this.map3CamPos.x > 322.0f) {
            this.map3CamPos.x = 322.0f;
        }
        if (this.map2WaterY < 1536.0f) {
            this.map2WaterY += 90.0f * deltaTime;
            if (this.map2WaterY > 1536.0f) {
                this.map2WaterY = 1536.0f;
            }
            this.seeFront.setTargetY((int)this.map2WaterY);
        }
        this.map2.update(deltaTime);
        this.room2Fall1.update(deltaTime);
        this.room2Fall1.setHeight(1536 - (int)this.map2WaterY + 200);
        this.room2Fall2.update(deltaTime);
        this.room2Fall2.setHeight(1536 - (int)this.map2WaterY + 200);
        for (FallingPlatform fallingPlatform : this.fallingBlocks) {
            fallingPlatform.update(deltaTime);
        }
        for (FallingPlatform fallingPlatform : this.fallenBlocks) {
            fallingPlatform.update(deltaTime);
        }
        for (Damageable damageable : this.ceilingTargets) {
            damageable.update(deltaTime);
            if (damageable.getState() == EntityState.Destroyed) {
                this.toRemove.addFirst(damageable);
            }
            if (!damageable.hasCreatedEntities()) continue;
            this.toAdd.addFirst(damageable.getCreatedEntities());
        }
        for (GameEntity gameEntity : this.entities) {
            gameEntity.update(deltaTime);
            if (gameEntity.getState() == EntityState.Destroyed) {
                this.toRemove.addFirst(gameEntity);
            } else if (gameEntity instanceof Rubble) {
                ((Rubble)gameEntity).setWaterLevel(this.map2WaterY, this.splash);
            }
            if (!gameEntity.hasCreatedEntities()) continue;
            this.toAdd.addFirst(gameEntity.getCreatedEntities());
        }
        if (playerPos.y + 64.0f < this.map2Y - (float)(Gdx.graphics.getHeight() / 2)) {
            this.player.destroy();
        }
        if (playerPos.y < this.map2WaterY) {
            if (!this.player.getIsUnderwater()) {
                this.splash.play(0.5f);
                this.player.setIsUnderwater(true, true);
            }
        } else if (this.player.getIsUnderwater()) {
            this.player.setIsUnderwater(false, true);
        }
        this.player.update(deltaTime);
        if (this.player.hasCreatedEntities()) {
            this.toAdd.addFirst(this.player.getCreatedEntities());
        }
        if (this.seeSide.getState() != EntityState.Destroyed) {
            this.seeSide.setTargetY((int)this.map2WaterY);
            this.seeSide.update(deltaTime);
            if (this.seeSide.hasCreatedEntities()) {
                this.toAdd.addFirst(this.seeSide.getCreatedEntities());
            }
        }
        this.playerHealth.setValue((float)this.player.getHealth() / (float)this.player.getMaxHealth());
        this.playerHealth.draw(this.hudRenderer);
        if (this.enemyHealth.getX() < ENEMY_HEALTH_TARGET_X) {
            int n = Math.min(40, ENEMY_HEALTH_TARGET_X - this.enemyHealth.getX());
            this.enemyHealth.setPosition(this.enemyHealth.getX() + n, this.enemyHealth.getY());
        }
        this.enemyHealth.setValue((float)this.seeSide.getHealth() / (float)this.seeSide.getMaxHealth());
        if (this.enemyHealth.getValue() > 0.0f) {
            this.enemyHealth.draw(this.hudRenderer);
        }
        this.entities.removeAll(this.toRemove);
        for (GameEntity[] gameEntityArray : this.toAdd) {
            this.entities.addAll(Arrays.asList(gameEntityArray));
        }
        this.toAdd.clear();
        this.toRemove.clear();
        if (this.seeSide.getHealth() <= 0) {
            if (this.seeSide.getState() == EntityState.Destroyed) {
                this.playerHealth.setInDanger(false);
                if (!this.fallingBlocks.isEmpty()) {
                    this.map3ExitBridgeFallTimer += deltaTime;
                    if (this.map3ExitBridgeFallTimer >= 0.1f) {
                        FallingPlatform fallingPlatform = this.fallingBlocks.removeFirst();
                        fallingPlatform.fall();
                        this.fallenBlocks.add(fallingPlatform);
                        this.map3ExitBridgeFallTimer = 0.0f;
                    }
                }
                this.music1.stop();
                this.music2.stop();
                if (!this.player.getIsInAir() && this.player.getHitArea()[0].overlaps(this.room3Exit.getHitArea()[0]) && (Gdx.input.isKeyPressed(20) || Gdx.input.isKeyPressed(47))) {
                    this.setupMap4();
                    this.currentMap = 4;
                }
            } else if (this.cameraShake == 0.0f) {
                this.cameraShake = 15.0f;
            }
        }
    }

    private void renderMap3(float deltaTime, PerspectiveCamera perspCam, OrthographicCamera orthoCam) {
        orthoCam.position.x = this.map3CamPos.x;
        orthoCam.position.y = this.map3CamPos.y + this.cameraShake;
        orthoCam.update();
        if (this.cameraShake > 0.0f) {
            this.cameraShake = -this.cameraShake + 0.5f;
        } else if (this.cameraShake < 0.0f) {
            this.cameraShake = -this.cameraShake - 0.5f;
        }
        Renderer renderer = new Renderer(orthoCam.combined);
        float halfWidth = 350.0f;
        float minVisibleX = orthoCam.position.x - halfWidth;
        float minVisibleY = orthoCam.position.y - 188.0f;
        this.visibleRegion.set(minVisibleX, minVisibleY, 700.0f, 376.0f);
        this.map2.render(deltaTime, this.visibleRegion, renderer);
        this.room2Fall1.draw(renderer);
        this.room2Fall2.draw(renderer);
        for (FallingPlatform fallingPlatform : this.fallingBlocks) {
            fallingPlatform.draw(renderer);
        }
        for (FallingPlatform fallingPlatform : this.fallenBlocks) {
            fallingPlatform.draw(renderer);
        }
        for (Damageable damageable : this.ceilingTargets) {
            damageable.draw(renderer);
        }
        for (GameEntity gameEntity : this.entities) {
            gameEntity.draw(renderer);
        }
        this.player.draw(renderer);
        if (this.seeSide.getState() != EntityState.Destroyed) {
            this.seeSide.draw(renderer);
        }
        renderer.drawRect(ShapeRenderer.ShapeType.Filled, WATER_COLOR, 0.0f, 1036.0f, 640.0f, this.map2WaterY - 1036.0f);
        this.playerHealth.draw(this.hudRenderer);
        if (this.enemyHealth.getValue() > 0.0f) {
            this.enemyHealth.draw(this.hudRenderer);
        }
    }

    private void setupMap4() {
        this.missionComplete = new TextureRegion(this.t_tiles1, 0, 594, 208, 24);
        this.music1.stop();
        this.music2.stop();
        this.unlockedCheat = this.getUnlockedCheat();
    }

    private void updateMap4(float deltaTime, int difficulty) {
        if (Gdx.input.isKeyPressed(66)) {
            this.state = GameState.Win;
        }
    }

    private void renderMap4(float deltaTime, PerspectiveCamera perspCam, OrthographicCamera orthoCam) {
        Gdx.gl.glClear(16640);
        float baseY = 3 * this.missionComplete.getRegionHeight();
        this.hudRenderer.drawRegion(this.missionComplete, (float)(-this.missionComplete.getRegionWidth()) / 2.0f, baseY);
        this.font.setScale(1.0f);
        BitmapFont.TextBounds bounds = this.font.getBounds((CharSequence)WIN_MESSAGE);
        this.hudRenderer.drawText(this.font, WIN_MESSAGE, -bounds.width / 2.0f, baseY - (float)this.missionComplete.getRegionHeight() / 2.0f);
        bounds = this.font.getBounds((CharSequence)"Press Enter to Play Again");
        this.hudRenderer.drawText(this.font, "Press Enter to Play Again", -bounds.width / 2.0f, baseY - (float)this.missionComplete.getRegionHeight() / 2.0f - bounds.height);
        String[] CREDITS = new String[]{"", "Created by:", "Emeltee, Pitch and Canticleer Blues", "", "Based on original concept \"Seeteufel\" by MegaMan Legends Station", "", "Special Thanks:", "Dashe, Raijin, Inclover, General Specific, Trege,", "Buster Cannon, Rockxas, Rockman Striker and Hirovoid", "", "Uses Resources from Sky Pirate Arcade", "Music by Dash Myoku"};
        int i = 1;
        while (i <= CREDITS.length) {
            String current = CREDITS[i - 1];
            BitmapFont.TextBounds temp = this.font.getBounds((CharSequence)current);
            this.hudRenderer.drawText(this.font, current, -temp.width / 2.0f, baseY - (float)(2 * this.missionComplete.getRegionHeight()) - ((float)i + 1.0f) * temp.height);
            ++i;
        }
        this.showUnlockedCheat(this.unlockedCheat);
    }

    private void showUnlockedCheat(GameCheat cheat) {
        String cheatHead = "";
        String cheatName = "Not all hidden treasures are refractors";
        String cheatSeq = "try again";
        if (this.unlockedCheat != null) {
            cheatHead = "! New Ability Unlocked !";
            cheatName = "GET EQUIPPED WITH: " + this.unlockedCheat.getDescription();
            cheatSeq = this.unlockedCheat.getSequenceString();
        } else if (this.player.isGeminiEnabled()) {
            cheatHead = "! CONGRATULATIONS !";
            cheatName = "You discovered the secret weapon 'Gemini Buster'.";
            cheatSeq = "There are more hidden secrets for stylish players. Keep playing!";
        }
        BitmapFont.TextBounds bounds = this.font.getBounds((CharSequence)cheatHead);
        this.hudRenderer.drawText(this.font, cheatHead, -bounds.width / 2.0f, -188.0f + 4.5f * bounds.height);
        bounds = this.font.getBounds((CharSequence)cheatName);
        this.hudRenderer.drawText(this.font, cheatName, -bounds.width / 2.0f, -188.0f + 3.0f * bounds.height);
        bounds = this.font.getBounds((CharSequence)cheatSeq);
        this.hudRenderer.drawText(this.font, cheatSeq, -bounds.width / 2.0f, -188.0f + 1.5f * bounds.height);
    }

    private GameCheat getUnlockedCheat() {
        BusterMaxCheat tempBusterMax = new BusterMaxCheat(this.player);
        GeminiShotCheat tempGeminiShot = new GeminiShotCheat(this.player);
        JumpSpringsCheat tempJumpSprings = new JumpSpringsCheat(this.player);
        KevlarOmegaArmorCheat tempKevlarOmega = new KevlarOmegaArmorCheat(this.player);
        HadoukenCheat tempHadouken = new HadoukenCheat(this.player);
        if (this.cheatEngine.getEnabledCheats().size() == this.cheatEngine.getAllCheats().size() || this.cheatEngine.getEnabledCheats().size() == this.cheatEngine.getAllCheats().size() - 1 && !this.cheatEngine.hasEnabledCheat(tempHadouken)) {
            return tempGeminiShot;
        }
        if (this.bypassedSeeteufel && !this.cheatEngine.hasEnabledCheat(tempBusterMax)) {
            return tempBusterMax;
        }
        if (!this.bypassedSeeteufel && (float)this.player.getHealth() >= 0.6666667f * (float)this.player.getMaxHealth() && !this.cheatEngine.hasEnabledCheat(tempBusterMax) && !this.cheatEngine.hasEnabledCheat(tempKevlarOmega)) {
            return tempKevlarOmega;
        }
        if (this.reachedArenaBeforeCamera && !this.cheatEngine.hasEnabledCheat(tempJumpSprings)) {
            return tempJumpSprings;
        }
        return null;
    }

    public static class MapTiles {
        public Texture rockTex = null;
        public Texture wallTex = null;
        public Texture smallMazeTex = null;
        public Texture largeMazeTex = null;
        public Texture stairTex = null;
        public Texture pillarTex = null;
        public Texture greyBlockTex = null;
        public Texture bonusTex = null;
        private boolean isLoaded = false;

        public void load() {
            if (!this.isLoaded) {
                this.rockTex = new Texture("img/tile1.png");
                this.rockTex.setWrap(Texture.TextureWrap.Repeat, Texture.TextureWrap.Repeat);
                this.wallTex = new Texture("img/tile2.png");
                this.wallTex.setWrap(Texture.TextureWrap.Repeat, Texture.TextureWrap.Repeat);
                this.smallMazeTex = new Texture("img/tile4.png");
                this.smallMazeTex.setWrap(Texture.TextureWrap.Repeat, Texture.TextureWrap.Repeat);
                this.largeMazeTex = new Texture("img/tile6.png");
                this.largeMazeTex.setWrap(Texture.TextureWrap.Repeat, Texture.TextureWrap.Repeat);
                this.pillarTex = new Texture("img/tile3.png");
                this.pillarTex.setWrap(Texture.TextureWrap.Repeat, Texture.TextureWrap.Repeat);
                this.greyBlockTex = new Texture("img/tile5.png");
                this.greyBlockTex.setWrap(Texture.TextureWrap.Repeat, Texture.TextureWrap.Repeat);
                this.bonusTex = new Texture("img/nadia.png");
                this.bonusTex.setWrap(Texture.TextureWrap.Repeat, Texture.TextureWrap.Repeat);
                this.isLoaded = true;
            }
        }

        public void unload() {
            if (this.isLoaded) {
                this.rockTex.dispose();
                this.wallTex.dispose();
                this.smallMazeTex.dispose();
                this.pillarTex.dispose();
                this.isLoaded = false;
            }
        }
    }
}

