/*
 * Decompiled with CFR 0.152.
 */
package com.me.mygdxgame.entities.projectiles;

import com.badlogic.gdx.audio.Sound;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector3;
import com.me.mygdxgame.entities.particles.Splash;
import com.me.mygdxgame.utilities.Damageable;
import com.me.mygdxgame.utilities.Damager;
import com.me.mygdxgame.utilities.EntityState;
import com.me.mygdxgame.utilities.GameEntity;
import com.me.mygdxgame.utilities.Renderer;
import java.util.ArrayList;
import java.util.NoSuchElementException;

public abstract class Rubble
implements GameEntity,
Damager {
    protected TextureRegion rubble;
    protected Vector3 position;
    protected Vector3 velocity;
    protected EntityState state;
    protected GameEntity[] obstacles;
    protected Damageable[] targets;
    protected float lifetime = 2.0f;
    protected Rectangle hitbox = new Rectangle(0.0f, 0.0f, 0.0f, 0.0f);
    protected Rectangle[] area = new Rectangle[]{this.hitbox};
    protected static final float GRAVITY = 800.0f;
    protected static final float INERTIA = 200.0f;
    protected static final float MIN_X_VELOCITY = 12.0f;
    private static final float MIN_Y_VELOCITY = -20000.0f;
    protected int x;
    protected int y;
    protected int w;
    protected int h;
    protected int power = 0;
    protected int knockback = 0;
    protected float scale = 1.0f;
    protected boolean isUnderwater = true;
    protected ArrayList<GameEntity> createdEntities = new ArrayList();

    public Rubble(int x, int y, int width, int height) {
        this.hitbox.set((float)x, (float)y, (float)width, (float)height);
    }

    public void setWaterLevel(float waterLevel, Sound splashSound) {
        if (this.isUnderwater) {
            if (this.position.y > waterLevel) {
                this.isUnderwater = false;
            }
        } else if (this.position.y < waterLevel) {
            this.isUnderwater = true;
            this.splash(splashSound);
        }
    }

    private void splash(Sound splashSound) {
        float adjustedX = this.position.x + (float)(this.rubble.getRegionWidth() / 2);
        int x = 0;
        while (x < 2) {
            this.createdEntities.add(new Splash(adjustedX, this.position.y, (float)(Math.random() * 75.0), (float)((Math.random() * 0.25 + 0.75) * 225.0), 3));
            this.createdEntities.add(new Splash(adjustedX, this.position.y, (float)(-Math.random() * 75.0), (float)((Math.random() * 0.25 + 0.75) * 225.0), 3));
            ++x;
        }
    }

    @Override
    public void update(float deltaTime) {
        if (this.state == EntityState.Running) {
            Rectangle r;
            int n;
            int n2;
            Rectangle[] rectangleArray;
            this.position.add(this.velocity.cpy().scl(deltaTime));
            this.velocity.y = Math.max(-20000.0f * deltaTime, this.velocity.y - 800.0f * deltaTime);
            this.velocity.x = Math.abs(this.velocity.x) < 12.0f * deltaTime ? 0.0f : (this.velocity.x > 0.0f ? (this.velocity.x -= 200.0f * deltaTime) : (this.velocity.x += 200.0f * deltaTime));
            this.hitbox.setPosition(this.position.x, this.position.y);
            this.lifetime -= deltaTime;
            if (this.lifetime < 0.0f) {
                this.state = EntityState.Destroyed;
                return;
            }
            GameEntity[] gameEntityArray = this.obstacles;
            int n3 = this.obstacles.length;
            int n4 = 0;
            while (n4 < n3) {
                GameEntity entity = gameEntityArray[n4];
                rectangleArray = entity.getHitArea();
                n2 = rectangleArray.length;
                n = 0;
                while (n < n2) {
                    r = rectangleArray[n];
                    if (r.overlaps(new Rectangle(this.position.x, this.position.y, (float)this.w, (float)this.h))) {
                        this.state = EntityState.Destroyed;
                        return;
                    }
                    ++n;
                }
                ++n4;
            }
            gameEntityArray = this.targets;
            n3 = this.targets.length;
            n4 = 0;
            while (n4 < n3) {
                GameEntity d = gameEntityArray[n4];
                rectangleArray = d.getHitArea();
                n2 = rectangleArray.length;
                n = 0;
                while (n < n2) {
                    r = rectangleArray[n];
                    if (r.overlaps(new Rectangle(this.position.x, this.position.y, (float)this.w, (float)this.h))) {
                        d.damage(this);
                        this.state = EntityState.Destroyed;
                        return;
                    }
                    ++n;
                }
                ++n4;
            }
        }
    }

    @Override
    public void draw(Renderer renderer) {
        if (this.state == EntityState.Running) {
            renderer.drawRegion(this.rubble, (int)this.position.x, (int)this.position.y, Color.WHITE, this.scale, this.scale, 0);
        }
    }

    @Override
    public EntityState getState() {
        return this.state;
    }

    @Override
    public boolean hasCreatedEntities() {
        return !this.createdEntities.isEmpty();
    }

    @Override
    public GameEntity[] getCreatedEntities() throws NoSuchElementException {
        if (this.createdEntities.isEmpty()) {
            throw new NoSuchElementException();
        }
        GameEntity[] entities = new GameEntity[this.createdEntities.size()];
        entities = this.createdEntities.toArray(entities);
        this.createdEntities.clear();
        return entities;
    }

    @Override
    public Rectangle[] getHitArea() {
        return this.area;
    }

    @Override
    public void destroy() {
        this.state = EntityState.Destroyed;
    }

    @Override
    public Vector3 getPosition() {
        return new Vector3(this.position);
    }

    @Override
    public int getWidth() {
        return (int)this.hitbox.width;
    }

    @Override
    public int getHeight() {
        return (int)this.hitbox.height;
    }

    @Override
    public int getPower() {
        return this.power;
    }

    @Override
    public int getKnockback() {
        return this.knockback;
    }
}

