/*
 * Decompiled with CFR 0.152.
 */
package com.me.mygdxgame.entities.progressbars;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.Vector3;
import com.me.mygdxgame.utilities.ProgressBar;
import com.me.mygdxgame.utilities.Renderer;

public class BonneHealthBar
implements ProgressBar {
    private static final int LOGO_X = 0;
    private static final int LOGO_Y = 496;
    private static final int LOGO_W = 32;
    private static final int LOGO_H = 32;
    private static final int BAR_W = 600;
    private static final int BAR_H = 12;
    private static final int BAR_X = 16;
    private static final int BAR_Y = 10;
    private static final Color BAR_COLOR = Color.RED;
    private static final Color BAR_OUTLINE = Color.DARK_GRAY;
    protected float value = 1.0f;
    private int barSize = 1;
    private int x;
    private int y;
    private TextureRegion logo;

    public BonneHealthBar(Texture spriteSheet, int x, int y) {
        this.logo = new TextureRegion(spriteSheet, 0, 496, 32, 32);
        this.x = x;
        this.y = y;
    }

    public void setPosition(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    @Override
    public void update(float deltaTime) {
    }

    @Override
    public void draw(Renderer renderer) {
        renderer.drawRect(ShapeRenderer.ShapeType.Filled, BAR_COLOR, this.x + 16, this.y + 10, this.barSize, 12.0f);
        renderer.drawRect(ShapeRenderer.ShapeType.Line, BAR_OUTLINE, this.x + 16, this.y + 10, this.barSize, 12.0f);
        renderer.drawRegion(this.logo, this.x, this.y);
    }

    @Override
    public void setValue(float value) {
        this.value = Math.max(0.0f, Math.min(1.0f, value));
        this.barSize = Math.max(0, (int)Math.ceil(this.value * 600.0f));
    }

    @Override
    public float getValue() {
        return this.value;
    }

    @Override
    public Vector3 getPosition() {
        return new Vector3((float)this.x, (float)this.y, 0.0f);
    }

    @Override
    public int getWidth() {
        return 600;
    }

    @Override
    public int getHeight() {
        return 32;
    }
}

