/*
 * Decompiled with CFR 0.152.
 */
package com.me.mygdxgame.entities.obstacles;

import com.badlogic.gdx.audio.Sound;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.math.Rectangle;
import com.me.mygdxgame.entities.obstacles.Platform;
import com.me.mygdxgame.screens.seeteufelscreen.SeeteufelScreen;
import com.me.mygdxgame.utilities.EntityState;

public class FallingPlatform
extends Platform {
    private static final int GRAVITY = 400;
    private int destinationY;
    private boolean hasLanded;
    private Sound landingSound;
    private Rectangle[] emptyHitArea = new Rectangle[0];
    private Rectangle[] hitArea = new Rectangle[1];

    public FallingPlatform(Texture spriteSheet, SeeteufelScreen.MapTiles tiles, Sound landSound, int x, int y, int destinationY) {
        super(spriteSheet, tiles, x, y);
        this.destinationY = destinationY;
        this.hasLanded = true;
        this.landingSound = landSound;
        this.hitArea[0] = this.hitbox;
    }

    @Override
    public void update(float deltaTime) {
        if (this.status == EntityState.Running) {
            if (this.health <= 0) {
                this.explode();
                this.status = EntityState.Destroyed;
            }
            if (!this.hasLanded) {
                if (this.y > this.destinationY) {
                    this.y = (int)Math.max((float)this.y - 400.0f * deltaTime, (float)this.destinationY);
                    this.hitbox.y = this.y;
                } else {
                    this.hasLanded = true;
                    this.landingSound.stop();
                    this.landingSound.play();
                }
            }
        }
    }

    @Override
    public Rectangle[] getHitArea() {
        return this.hasLanded ? this.hitArea : this.emptyHitArea;
    }

    public void setTargetY(int targetY) {
        this.destinationY = targetY;
    }

    public boolean hasFallen() {
        return this.hasLanded;
    }

    public void fall() {
        this.hasLanded = false;
    }
}

