/*
 * Decompiled with CFR 0.152.
 */
package com.me.mygdxgame.entities;

import com.badlogic.gdx.audio.Sound;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector3;
import com.me.mygdxgame.entities.MegaPlayer;
import com.me.mygdxgame.entities.particles.Explosion;
import com.me.mygdxgame.entities.projectiles.Bomb;
import com.me.mygdxgame.entities.projectiles.BusterShot;
import com.me.mygdxgame.entities.projectiles.LemonShot;
import com.me.mygdxgame.entities.projectiles.Rocket;
import com.me.mygdxgame.utilities.Damageable;
import com.me.mygdxgame.utilities.Damager;
import com.me.mygdxgame.utilities.EntityState;
import com.me.mygdxgame.utilities.GameEntity;
import com.me.mygdxgame.utilities.Renderer;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;

public class SeeteufelSide
implements GameEntity,
Damageable {
    private static final int TARGET_Y_OFFSET = 20;
    private static final int BASE_WIDTH = 72;
    private static final int MAX_HEALTH = 130;
    private static final int HEALTH_THRESHOLD_1 = 86;
    private static final int HEALTH_THRESHOLD_2 = 43;
    private static final float FRONT_ARM_FRAMERATE = 0.2f;
    private static final float SIDE_ARM_FRAMERATE = 0.425f;
    private static final int OBSTACLE_HITBOX_WIDTH = 140;
    private static final float MOVE_SPEED = 60.0f;
    private static final float BASE_ATTACK_DELAY = 1.0f;
    private static final float MIN_ATTACK_DELAY = 0.5f;
    private static final float ATTACK_DELAY_RAMP = 0.004f;
    private static final float CEILING_ATTACK_CHANCE = 0.2f;
    private static final float CEILING_ATTACK_COOLDOWN = 1.0f;
    private static final int ROCKET_POWER = 8;
    private static final int ROCKET_KNOCKBACK = 15;
    private static final float ROCKET_SPEED = 200.0f;
    private static final int SINK_SPEED = 50;
    private static final int SINK_DEPTH = 150;
    private static final float SINK_EXPLOSION_DELAY = 0.2f;
    private static final int[] SHOT_HEIGHTS = new int[]{60, 60, 60, 60, 92, 124};
    private static final int[] SHOT_QUANTITY = new int[]{1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 4, 4, 5};
    private static final int BASE_SHOT_SPEED = 300;
    private static final int BASE_SHOT_POWER = 5;
    private static final float BASE_SHOT_RANGE = 1000.0f;
    private static final float SFX_VOLUME = 0.5f;
    private Vector3 position;
    private Collection<Damageable> targets;
    private Collection<Damageable> ceilingTargets;
    private Collection<GameEntity> obstacles;
    private TextureRegion front = null;
    private TextureRegion[] frontArm = new TextureRegion[6];
    private TextureRegion[] sideArmBack = new TextureRegion[3];
    private TextureRegion[] sideArmFront = new TextureRegion[3];
    private Texture spritesheet = null;
    private Sound explosion = null;
    private Sound shoot = null;
    private Sound damage = null;
    private MegaPlayer.MegaPlayerResources otherSounds = null;
    private boolean frontArmAnimDir = true;
    private int frontArmFrame = 0;
    private int sideArmFrame = 0;
    private float frontArmTimer = 0.0f;
    private float sideArmTimer = 0.0f;
    private int targetY = 0;
    private EntityState state = EntityState.Running;
    private int health = 130;
    private boolean moving = true;
    private boolean shootLemons = true;
    private float destroyedTargetY = 0.0f;
    private LinkedList<Explosion> explosions = new LinkedList();
    private boolean shootLemonLine = true;
    private float attackDelayTimer = 0.0f;
    private float cielingAttackDelayTimer = 0.0f;
    private LinkedList<GameEntity> createdEntities = new LinkedList();
    private Rectangle[] hitArea = new Rectangle[1];
    private Rectangle movementHitArea = new Rectangle(0.0f, 0.0f, 0.0f, 0.0f);

    public SeeteufelSide(Texture spritesheet, Sound explosion, Sound shoot, Sound damage, MegaPlayer.MegaPlayerResources otherSounds, Vector3 position, Collection<Damageable> targets, Collection<GameEntity> obstacles, Collection<Damageable> ceilingTargets) {
        TextureRegion region;
        this.position = new Vector3(position);
        this.position.x -= 36.0f;
        this.position.y -= 20.0f;
        this.targets = targets;
        this.ceilingTargets = new LinkedList<Damageable>(ceilingTargets);
        this.obstacles = obstacles;
        this.hitArea[0] = new Rectangle(position.x, position.y, 72.0f, 115.0f);
        this.movementHitArea = new Rectangle(0.0f, 0.0f, 140.0f, 115.0f);
        this.explosion = explosion;
        this.shoot = shoot;
        this.damage = damage;
        this.otherSounds = otherSounds;
        this.front = new TextureRegion(spritesheet, 256, 211, 72, 115);
        this.spritesheet = spritesheet;
        this.frontArm[0] = new TextureRegion(spritesheet, 275, 20, 101, 77);
        this.frontArm[1] = new TextureRegion(spritesheet, 388, 14, 111, 84);
        this.frontArm[2] = new TextureRegion(spritesheet, 500, 25, 122, 73);
        this.frontArm[3] = new TextureRegion(spritesheet, 278, 103, 100, 103);
        this.frontArm[4] = new TextureRegion(spritesheet, 546, 98, 76, 113);
        this.frontArm[5] = new TextureRegion(spritesheet, 441, 98, 59, 113);
        TextureRegion[] textureRegionArray = this.frontArm;
        int n = this.frontArm.length;
        int n2 = 0;
        while (n2 < n) {
            region = textureRegionArray[n2];
            region.flip(true, false);
            ++n2;
        }
        this.sideArmFront[0] = new TextureRegion(spritesheet, 256, 334, 113, 28);
        this.sideArmFront[1] = new TextureRegion(spritesheet, 370, 334, 113, 24);
        this.sideArmFront[2] = new TextureRegion(spritesheet, 484, 325, 113, 29);
        this.sideArmBack[0] = new TextureRegion(spritesheet, 256, 370, 113, 28);
        this.sideArmBack[1] = new TextureRegion(spritesheet, 370, 370, 113, 24);
        this.sideArmBack[2] = new TextureRegion(spritesheet, 484, 362, 113, 29);
        textureRegionArray = this.sideArmFront;
        n = this.sideArmFront.length;
        n2 = 0;
        while (n2 < n) {
            region = textureRegionArray[n2];
            region.flip(true, false);
            ++n2;
        }
        textureRegionArray = this.sideArmBack;
        n = this.sideArmBack.length;
        n2 = 0;
        while (n2 < n) {
            region = textureRegionArray[n2];
            region.flip(true, false);
            ++n2;
        }
    }

    @Override
    public void update(float deltaTime) {
        if (this.state == EntityState.Running) {
            if (this.health <= 0) {
                LinkedList<Explosion> finishedExplosions = new LinkedList<Explosion>();
                for (Explosion explosion : this.explosions) {
                    explosion.update(deltaTime);
                    if (explosion.getState() != EntityState.Destroyed) continue;
                    finishedExplosions.add(explosion);
                }
                this.explosions.removeAll(finishedExplosions);
                if (this.position.y > this.destroyedTargetY) {
                    this.position.y -= 50.0f * deltaTime;
                    this.hitArea[0].y = this.position.y;
                    this.attackDelayTimer += deltaTime;
                    if (this.attackDelayTimer >= 0.2f) {
                        this.explode();
                        this.attackDelayTimer = 0.0f;
                    }
                } else {
                    this.state = EntityState.Destroyed;
                    this.explosions.clear();
                }
                return;
            }
            this.position.y = this.targetY - 20;
            this.hitArea[0].x = this.position.x;
            this.hitArea[0].y = this.position.y;
            if (this.moving) {
                this.position.x -= 60.0f * deltaTime;
                this.movementHitArea.x = this.position.x - 70.0f;
                this.movementHitArea.y = this.position.y;
                for (GameEntity entity : this.obstacles) {
                    Rectangle[] rectangleArray = entity.getHitArea();
                    int n = rectangleArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Rectangle rect = rectangleArray[n2];
                        if (this.movementHitArea.overlaps(rect)) {
                            this.moving = false;
                            return;
                        }
                        ++n2;
                    }
                }
            } else {
                this.attackDelayTimer += deltaTime;
                this.cielingAttackDelayTimer += deltaTime;
                float attackDelay = Math.max(0.5f, 1.0f - (float)(130 - this.health) * 0.004f);
                if (this.attackDelayTimer > attackDelay) {
                    this.attackDelayTimer = 0.0f;
                    this.shoot.play(0.5f);
                    float ceilingAttackChance = 0.0f;
                    if (this.cielingAttackDelayTimer >= 1.0f) {
                        ceilingAttackChance = 0.2f + 0.1f * ((float)(130 - this.health) / 130.0f);
                        this.cielingAttackDelayTimer = 0.0f;
                    }
                    if (Math.random() <= (double)ceilingAttackChance && !this.ceilingTargets.isEmpty()) {
                        int index = (int)(Math.random() * (double)this.ceilingTargets.size());
                        Damageable target = this.ceilingTargets.iterator().next();
                        Iterator<Damageable> itr = this.ceilingTargets.iterator();
                        int x = 0;
                        while (x < index) {
                            target = itr.next();
                            ++x;
                        }
                        Vector3 targetPos = target.getPosition();
                        Vector3 rocketPosition = this.position.cpy();
                        rocketPosition.x += 36.0f;
                        Vector3 targetPosition = new Vector3(targetPos.x - rocketPosition.x, targetPos.y - rocketPosition.y, 0.0f);
                        this.createdEntities.add(new Rocket(this.spritesheet, this.explosion, rocketPosition, targetPosition.nor().scl(200.0f), 1, 0, new GameEntity[0], new Damageable[]{target}));
                    }
                    if (this.health < 43) {
                        if (Math.random() <= 0.2) {
                            this.shootLemons = !this.shootLemons;
                        }
                    } else if (this.health < 86) {
                        this.shootLemons = false;
                        this.shootLemonLine = false;
                    }
                    if (this.shootLemons) {
                        int shotHeight = SHOT_HEIGHTS[(int)(Math.random() * (double)SHOT_HEIGHTS.length)];
                        int numShots = 1;
                        if (this.shootLemonLine) {
                            numShots = SHOT_QUANTITY[(int)(Math.random() * (double)SHOT_QUANTITY.length)];
                        }
                        Vector3 shotPos = new Vector3(this.position.x, this.position.y + (float)shotHeight, 0.0f);
                        int i = 0;
                        while (i < numShots) {
                            LemonShot newShot = new LemonShot(this.spritesheet, this.otherSounds.shotMissSound, shotPos, 300, BusterShot.ShotDirection.LEFT, 5, 1000.0f, this.obstacles, this.targets);
                            this.createdEntities.offer(newShot);
                            shotPos.x += (float)newShot.getWidth();
                            ++i;
                        }
                    } else {
                        Vector3 rocketVel = new Vector3((float)(-Math.random() * 200.0 - 60.0), 260.0f, 0.0f);
                        Damageable[] currentTargets = new Damageable[this.targets.size()];
                        currentTargets = this.targets.toArray(currentTargets);
                        GameEntity[] currentObstacles = new GameEntity[this.obstacles.size()];
                        currentObstacles = this.obstacles.toArray(currentObstacles);
                        this.createdEntities.offer(new Bomb(this.spritesheet, this.explosion, this.position, rocketVel, 8, 15, currentObstacles, currentTargets));
                    }
                }
            }
            this.sideArmTimer += deltaTime;
            if (this.sideArmTimer >= 0.425f) {
                this.sideArmFrame = (this.sideArmFrame + 1) % 3;
                this.sideArmTimer = 0.0f;
            }
            this.frontArmTimer += deltaTime;
            if (this.frontArmTimer >= 0.2f) {
                if (this.frontArmAnimDir) {
                    ++this.frontArmFrame;
                    if (this.frontArmFrame == 5) {
                        this.frontArmAnimDir = false;
                    }
                } else {
                    --this.frontArmFrame;
                    if (this.frontArmFrame == 0) {
                        this.frontArmAnimDir = true;
                    }
                }
                this.frontArmTimer = 0.0f;
            }
        }
    }

    @Override
    public void draw(Renderer renderer) {
        if (this.frontArmFrame == 0) {
            this.frontArm[0].flip(true, false);
            renderer.drawRegion(this.frontArm[0], this.position.x - 62.0f, this.position.y + 32.0f);
            this.frontArm[0].flip(true, false);
            renderer.drawRegion(this.frontArm[0], this.position.x + 50.0f, this.position.y + 32.0f);
        } else if (this.frontArmFrame == 1) {
            this.frontArm[1].flip(true, false);
            renderer.drawRegion(this.frontArm[1], this.position.x - 73.0f, this.position.y + 28.0f);
            this.frontArm[1].flip(true, false);
            renderer.drawRegion(this.frontArm[1], this.position.x + 50.0f, this.position.y + 28.0f);
        } else if (this.frontArmFrame == 2) {
            this.frontArm[2].flip(true, false);
            renderer.drawRegion(this.frontArm[2], this.position.x - 85.0f, this.position.y + 31.0f);
            this.frontArm[2].flip(true, false);
            renderer.drawRegion(this.frontArm[2], this.position.x + 50.0f, this.position.y + 31.0f);
        } else if (this.frontArmFrame == 3) {
            this.frontArm[3].flip(true, false);
            renderer.drawRegion(this.frontArm[3], this.position.x - 60.0f, this.position.y + 18.0f);
            this.frontArm[3].flip(true, false);
            renderer.drawRegion(this.frontArm[3], this.position.x + 50.0f, this.position.y + 18.0f);
        } else if (this.frontArmFrame == 4) {
            this.frontArm[4].flip(true, false);
            renderer.drawRegion(this.frontArm[4], this.position.x - 37.0f, this.position.y + 16.0f);
            this.frontArm[4].flip(true, false);
            renderer.drawRegion(this.frontArm[4], this.position.x + 50.0f, this.position.y + 16.0f);
        } else {
            this.frontArm[5].flip(true, false);
            renderer.drawRegion(this.frontArm[5], this.position.x - 18.0f, this.position.y + 10.0f);
            this.frontArm[5].flip(true, false);
            renderer.drawRegion(this.frontArm[5], this.position.x + 50.0f, this.position.y + 10.0f);
        }
        if (this.sideArmFrame == 0) {
            renderer.drawRegion(this.sideArmBack[2], this.position.x - 78.0f, this.position.y + 14.0f);
        } else if (this.sideArmFrame == 1) {
            renderer.drawRegion(this.sideArmBack[0], this.position.x - 78.0f, this.position.y + 18.0f);
        } else {
            renderer.drawRegion(this.sideArmBack[1], this.position.x - 78.0f, this.position.y + 22.0f);
        }
        renderer.drawRegion(this.front, this.position.x, this.position.y);
        if (this.sideArmFrame == 0) {
            renderer.drawRegion(this.sideArmFront[0], this.position.x - 66.0f, this.position.y + 14.0f);
        } else if (this.sideArmFrame == 1) {
            renderer.drawRegion(this.sideArmFront[1], this.position.x - 66.0f, this.position.y + 18.0f);
        } else {
            renderer.drawRegion(this.sideArmFront[2], this.position.x - 66.0f, this.position.y + 22.0f);
        }
        for (Explosion explosion : this.explosions) {
            explosion.draw(renderer);
        }
    }

    private void explode() {
        this.explosions.add(new Explosion(this.spritesheet, new Vector3((float)((double)this.position.x + Math.random() * (double)this.front.getRegionWidth()), (float)((double)this.position.y + Math.random() * (double)this.front.getRegionHeight()), this.position.z)));
        this.explosion.play(0.5f);
    }

    public void setTargetY(int targetY) {
        this.targetY = targetY;
    }

    public int getTargetY() {
        return this.targetY;
    }

    @Override
    public EntityState getState() {
        return this.state;
    }

    @Override
    public boolean hasCreatedEntities() {
        return !this.createdEntities.isEmpty();
    }

    @Override
    public Rectangle[] getHitArea() {
        return this.hitArea;
    }

    @Override
    public void destroy() {
        this.state = EntityState.Destroyed;
    }

    @Override
    public GameEntity[] getCreatedEntities() throws NoSuchElementException {
        if (this.createdEntities.isEmpty()) {
            throw new NoSuchElementException("No entities to return.");
        }
        GameEntity[] newEntities = new GameEntity[this.createdEntities.size()];
        newEntities = this.createdEntities.toArray(newEntities);
        this.createdEntities.clear();
        return newEntities;
    }

    @Override
    public void damage(Damager damager) {
        boolean alive;
        boolean bl = alive = this.health > 0;
        if (damager.getPower() > 0) {
            this.health = Math.max(0, this.health - damager.getPower());
            this.damage.play(0.5f);
        }
        if (alive && this.health <= 0) {
            this.destroyedTargetY = this.position.y - 150.0f;
        }
    }

    @Override
    public int getHealth() {
        return this.health;
    }

    @Override
    public int getMaxHealth() {
        return 130;
    }

    @Override
    public Vector3 getPosition() {
        return new Vector3(this.position);
    }

    @Override
    public int getWidth() {
        return this.front.getRegionWidth();
    }

    @Override
    public int getHeight() {
        return this.front.getRegionHeight();
    }
}

