/*
 * Decompiled with CFR 0.152.
 */
package com.me.mygdxgame.entities;

import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Vector3;
import com.me.mygdxgame.utilities.Renderer;
import com.me.mygdxgame.utilities.Updatable;

public class LightPillar
implements Updatable {
    private static final int PILLAR_BASE_X = 0;
    private static final int PILLAR_BASE_Y = 44;
    private static final int PILLAR_BASE_W = 35;
    private static final int PILLAR_BASE_H = 13;
    private static final int BEAM_W = 35;
    private static final int BEAM_H = 11;
    private static final int FRAMES_X = 0;
    private static final int FRAME1_Y = 33;
    private static final int FRAME2_Y = 22;
    private static final int FRAME3_Y = 11;
    private static final int FRAME4_Y = 0;
    private static final float FRAMERATE = 0.15f;
    private Sprite[] pillarFrames;
    private TextureRegion lowerBase;
    private TextureRegion upperBase;
    private float animationTimer;
    private int frame;
    private int x;
    private int y;
    private int height;

    public LightPillar(Texture spriteSheet, int x, int y, int height) {
        this.lowerBase = new TextureRegion(spriteSheet, 0, 44, 35, 13);
        this.upperBase = new TextureRegion(this.lowerBase);
        this.upperBase.flip(false, true);
        this.pillarFrames = new Sprite[6];
        this.pillarFrames[0] = new Sprite(new TextureRegion(spriteSheet, 0, 33, 35, 11));
        this.pillarFrames[1] = new Sprite(new TextureRegion(spriteSheet, 0, 22, 35, 11));
        this.pillarFrames[2] = new Sprite(new TextureRegion(spriteSheet, 0, 11, 35, 11));
        this.pillarFrames[3] = new Sprite(new TextureRegion(spriteSheet, 0, 0, 35, 11));
        this.pillarFrames[4] = this.pillarFrames[3];
        this.pillarFrames[5] = this.pillarFrames[2];
        this.x = x;
        this.y = y;
        this.height = height;
        this.animationTimer = 0.0f;
        this.frame = 0;
    }

    @Override
    public void update(float deltaTime) {
        this.animationTimer += deltaTime;
        if (this.animationTimer > 0.15f) {
            this.animationTimer = 0.0f;
            this.frame = (this.frame + 1) % this.pillarFrames.length;
        }
    }

    @Override
    public void draw(Renderer renderer) {
        Sprite currentSprite = this.pillarFrames[this.frame];
        currentSprite.setBounds((float)this.x, (float)(this.y + 13), 35.0f, (float)(this.height - 26));
        renderer.drawSprite(currentSprite);
        renderer.drawRegion(this.lowerBase, this.x, this.y);
        renderer.drawRegion(this.upperBase, this.x, this.y + (this.height - 13));
    }

    public void renderBody(Renderer renderer) {
        Sprite currentSprite = this.pillarFrames[this.frame];
        currentSprite.setBounds((float)this.x, (float)(this.y + 13), 35.0f, (float)(this.height - 26));
        renderer.drawSprite(currentSprite);
    }

    public void renderBases(Renderer renderer) {
        renderer.drawRegion(this.lowerBase, this.x, this.y);
        renderer.drawRegion(this.upperBase, this.x, this.y + (this.height - 13));
    }

    @Override
    public Vector3 getPosition() {
        return new Vector3((float)this.x, (float)this.y, 0.0f);
    }

    @Override
    public int getWidth() {
        return 35;
    }

    @Override
    public int getHeight() {
        return this.height;
    }
}

