/*
 * Decompiled with CFR 0.152.
 */
package com.me.mygdxgame.utilities;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector3;
import com.me.mygdxgame.utilities.GameEntity;
import com.me.mygdxgame.utilities.Renderer;

public abstract class GameMap {
    protected boolean debugMode = false;
    public static final Color DEFAULT_OBSTACLE_COLOR = new Color(1.0f, 0.0f, 0.0f, 0.5f);

    public abstract Vector3 getInitialPosition();

    public abstract GameEntity getObstacles();

    public abstract void update(float var1);

    public abstract void render(float var1, Rectangle var2, Renderer var3);

    public void setDebugMode(boolean debugMode) {
        this.debugMode = debugMode;
    }

    protected static void drawObstacles(Renderer renderer, Rectangle[] obstacles, Color obstacleColor) {
        Rectangle[] rectangleArray = obstacles;
        int n = obstacles.length;
        int n2 = 0;
        while (n2 < n) {
            Rectangle rect = rectangleArray[n2];
            renderer.drawRect(ShapeRenderer.ShapeType.Filled, obstacleColor, rect.x, rect.y, rect.width, rect.height);
            ++n2;
        }
    }

    protected static void diagonalRight(Renderer renderer, TextureRegion pattern, int x, int y, int count) {
        int i = 0;
        while (i < count) {
            renderer.drawRegion(pattern, x + i * pattern.getRegionWidth(), y + i * pattern.getRegionHeight());
            ++i;
        }
    }

    protected static void diagonalLeft(Renderer renderer, TextureRegion pattern, int x, int y, int count) {
        int i = 0;
        while (i < count) {
            renderer.drawRegion(pattern, x - i * pattern.getRegionWidth(), y + i * pattern.getRegionHeight());
            ++i;
        }
    }

    protected static void tileX(Renderer renderer, TextureRegion pattern, int x, int y, int count) {
        int i = 0;
        while (i < count) {
            renderer.drawRegion(pattern, x + i * pattern.getRegionWidth(), y);
            ++i;
        }
    }

    protected static void tileY(Renderer renderer, TextureRegion pattern, int x, int y, int count) {
        int i = 0;
        while (i < count) {
            renderer.drawRegion(pattern, x, y + i * pattern.getRegionHeight());
            ++i;
        }
    }

    protected static void tileXY(Renderer renderer, TextureRegion pattern, int x, int y, int columns, int rows) {
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < columns) {
                renderer.drawRegion(pattern, x + j * pattern.getRegionWidth(), y + i * pattern.getRegionHeight());
                ++j;
            }
            ++i;
        }
    }

    protected static void checkerX(Renderer renderer, TextureRegion pattern, int x, int y, int count, int rows) {
        int i = 0;
        while (i < rows) {
            int j = i % 2 == 0 ? 0 : 1;
            while (j < 2 * count) {
                renderer.drawRegion(pattern, x + j * pattern.getRegionWidth(), y + i * pattern.getRegionHeight());
                j += 2;
            }
            ++i;
        }
    }

    protected static void checkerY(Renderer renderer, TextureRegion pattern, int x, int y, int count, int columns) {
        int i = 0;
        while (i < columns) {
            int j = i % 2 == 0 ? 0 : 1;
            while (j < 2 * count) {
                renderer.drawRegion(pattern, x + i * pattern.getRegionWidth(), y + j * pattern.getRegionHeight());
                j += 2;
            }
            ++i;
        }
    }
}

