/*
 * Decompiled with CFR 0.152.
 */
package com.me.mygdxgame.screens.seeteufelscreen.maps;

import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector3;
import com.me.mygdxgame.entities.LightBorder;
import com.me.mygdxgame.entities.LightPillar;
import com.me.mygdxgame.screens.seeteufelscreen.SeeteufelScreen;
import com.me.mygdxgame.utilities.GameEntity;
import com.me.mygdxgame.utilities.GameMap;
import com.me.mygdxgame.utilities.GenericEntity;
import com.me.mygdxgame.utilities.Renderer;
import java.util.Arrays;

public class SecondMap
extends GameMap {
    public static final int GROUND_DIM = 32;
    public static final int GROUND_ORIGIN_X = 0;
    public static final int GROUND_ORIGIN_Y = 0;
    public static final int GROUND_HEIGHT = 1;
    public static final int GROUND_WIDTH = 20;
    public static final int ARENA_HEIGHT = 10;
    public static final int ARENA_WIDTH = 10;
    public static final int ENTRANCE_PLAT_HEIGHT = 3;
    public static final int GROUND_END_X = 640;
    public static final int GROUND_START_Y = 32;
    private static final Vector3 INIT_POS = new Vector3(42.0f, 128.0f, 0.0f);
    private static final float PARALLAX_FACTOR = 0.5f;
    private int totalPixelHeight;
    private int height;
    private Sprite wallSprite;
    private Sprite shaftBackgroundSprite;
    private Sprite arenaBackgroundSprite;
    private Sprite arenaTransitionSprite;
    private LightPillar[] pillars;
    private LightBorder upperBorder;
    private Rectangle[] obstacles = null;
    private GenericEntity returnObstacles = null;

    public SecondMap(Texture spriteSheet, SeeteufelScreen.MapTiles tiles, int height) {
        this.height = height;
        this.totalPixelHeight = 320 + height * 32;
        this.wallSprite = new Sprite(tiles.wallTex);
        this.shaftBackgroundSprite = new Sprite(tiles.smallMazeTex);
        this.shaftBackgroundSprite.setBounds(32.0f, 32.0f, 576.0f, (float)((this.height - 1) * 32));
        this.shaftBackgroundSprite.setU2(18.0f);
        this.shaftBackgroundSprite.setV2(11.0f);
        this.arenaBackgroundSprite = new Sprite(tiles.largeMazeTex);
        this.arenaBackgroundSprite.setBounds(-288.0f, (float)(0 + (this.height + 1) * 32), 928.0f, 288.0f);
        this.arenaBackgroundSprite.setU2(14.5f);
        this.arenaBackgroundSprite.setV2(4.5f);
        this.arenaTransitionSprite = new Sprite(tiles.greyBlockTex);
        this.arenaTransitionSprite.setBounds(0.0f, (float)(0 + this.height * 32), 608.0f, 32.0f);
        this.arenaTransitionSprite.setU2(19.0f);
        this.arenaTransitionSprite.setV2(1.0f);
        int arenaStartX = -288;
        int arenaStartY = 0 + (this.height + 1) * 32;
        int borderWidth = 896;
        int borderOffsetY = 10;
        this.upperBorder = new LightBorder(spriteSheet, arenaStartX, arenaStartY + 256 - borderOffsetY, borderWidth);
        this.pillars = new LightPillar[]{new LightPillar(spriteSheet, arenaStartX + 32, arenaStartY, 256 - borderOffsetY), new LightPillar(spriteSheet, arenaStartX + 128, arenaStartY, 256 - borderOffsetY), new LightPillar(spriteSheet, arenaStartX + 224, arenaStartY, 256 - borderOffsetY)};
        this.obstacles = new Rectangle[]{new Rectangle(0.0f, 0.0f, 640.0f, 32.0f), new Rectangle(0.0f, 0.0f, 32.0f, (float)(this.height * 32)), new Rectangle(32.0f, 32.0f, 32.0f, 96.0f), new Rectangle(64.0f, 32.0f, 32.0f, 96.0f), new Rectangle(96.0f, 32.0f, 32.0f, 64.0f), new Rectangle(608.0f, 0.0f, 32.0f, (float)((this.height + 10) * 32)), new Rectangle(-320.0f, (float)(0 + this.height * 32), 352.0f, 32.0f), new Rectangle(-320.0f, (float)(0 + this.height * 32), 32.0f, 320.0f), new Rectangle(544.0f, (float)(0 + this.height * 32), 64.0f, 32.0f), new Rectangle(576.0f, (float)(0 + (this.height - 1) * 32), 32.0f, 32.0f), new Rectangle(-320.0f, (float)(0 + (this.height + 10 - 1) * 32), 960.0f, 32.0f)};
        this.returnObstacles = new GenericEntity(Arrays.asList(this.obstacles));
    }

    @Override
    public Vector3 getInitialPosition() {
        return INIT_POS;
    }

    @Override
    public GameEntity getObstacles() {
        return this.returnObstacles;
    }

    @Override
    public void render(float deltaTime, Rectangle visibleRegion, Renderer renderer) {
        float maxVisibleY = visibleRegion.getY() + visibleRegion.height;
        float adjustedMinY = Math.max(visibleRegion.y, 0.0f);
        float adjustedRegionHeight = visibleRegion.height;
        if (maxVisibleY > (float)this.totalPixelHeight) {
            adjustedRegionHeight -= maxVisibleY - (float)this.totalPixelHeight;
        }
        this.shaftBackgroundSprite.setBounds(this.shaftBackgroundSprite.getX(), adjustedMinY, this.shaftBackgroundSprite.getWidth(), adjustedRegionHeight);
        float adjustedBackgroundV = -visibleRegion.getY() * 0.5f / 32.0f;
        this.shaftBackgroundSprite.setV2(adjustedBackgroundV);
        this.shaftBackgroundSprite.setV(adjustedBackgroundV - adjustedRegionHeight / 32.0f);
        renderer.drawSprite(this.shaftBackgroundSprite);
        if (maxVisibleY >= this.arenaTransitionSprite.getY()) {
            renderer.drawSprite(this.arenaBackgroundSprite);
            renderer.drawSprite(this.arenaTransitionSprite);
        }
        Object[] objectArray = this.obstacles;
        int n = this.obstacles.length;
        int n2 = 0;
        while (n2 < n) {
            Rectangle rect = objectArray[n2];
            this.wallSprite.setBounds(rect.x, rect.y, rect.width, rect.height);
            this.wallSprite.setU2(rect.width / 32.0f);
            this.wallSprite.setV2(rect.height / 32.0f);
            renderer.drawSprite(this.wallSprite);
            ++n2;
        }
        if (maxVisibleY >= this.arenaTransitionSprite.getY()) {
            objectArray = this.pillars;
            n = this.pillars.length;
            n2 = 0;
            while (n2 < n) {
                Rectangle pillar = objectArray[n2];
                pillar.draw(renderer);
                ++n2;
            }
        }
        this.upperBorder.draw(renderer);
        if (this.debugMode) {
            SecondMap.drawObstacles(renderer, this.getObstacles().getHitArea(), GameMap.DEFAULT_OBSTACLE_COLOR);
        }
    }

    @Override
    public void update(float deltaTime) {
        LightPillar[] lightPillarArray = this.pillars;
        int n = this.pillars.length;
        int n2 = 0;
        while (n2 < n) {
            LightPillar pillar = lightPillarArray[n2];
            pillar.update(deltaTime);
            ++n2;
        }
        this.upperBorder.update(deltaTime);
    }
}

