/*
 * Decompiled with CFR 0.152.
 */
package com.me.mygdxgame.screens.entitytestscreen;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.PerspectiveCamera;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector3;
import com.me.mygdxgame.screens.entitytestscreen.EntityTestMap;
import com.me.mygdxgame.utilities.EntityState;
import com.me.mygdxgame.utilities.GameEntity;
import com.me.mygdxgame.utilities.GameScreen;
import com.me.mygdxgame.utilities.GameState;
import com.me.mygdxgame.utilities.Renderer;
import java.util.Iterator;
import java.util.LinkedList;

public class EntityTestScreen
implements GameScreen {
    private static Vector3 CAM_INITIAL_POSITION = new Vector3(0.0f, 0.0f, 256.0f);
    private Vector3 camPos = new Vector3(CAM_INITIAL_POSITION);
    private LinkedList<GameEntity> entities = new LinkedList();
    private LinkedList<GameEntity> toRemove = new LinkedList();
    private LinkedList<GameEntity[]> toAdd = new LinkedList();
    private EntityTestMap map = null;
    private Rectangle visibleArea = new Rectangle(-1000.0f, -1000.0f, 2000.0f, 2000.0f);

    public EntityTestScreen(int width, int height) {
        this.map = new EntityTestMap(width, height, EntityTestMap.DEFAULT_THICKNESS);
    }

    public void addEntity(GameEntity entity) {
        this.entities.addFirst(entity);
    }

    public int getEntityCount() {
        return this.entities.size();
    }

    public GameEntity getObstacles() {
        return this.map.getObstacles();
    }

    public Vector3 getInitialPosition() {
        return this.map.getInitialPosition();
    }

    @Override
    public void load() {
    }

    @Override
    public void unload() {
    }

    @Override
    public void render(float deltaTime, int difficulty, PerspectiveCamera perspCam, OrthographicCamera orthoCam) {
        if (Gdx.input.isKeyPressed(29)) {
            this.camPos.x -= 180.0f * deltaTime;
        }
        if (Gdx.input.isKeyPressed(32)) {
            this.camPos.x += 180.0f * deltaTime;
        }
        if (Gdx.input.isKeyPressed(47)) {
            this.camPos.y -= 180.0f * deltaTime;
        }
        if (Gdx.input.isKeyPressed(51)) {
            this.camPos.y += 180.0f * deltaTime;
        }
        if (Gdx.input.isKeyPressed(33)) {
            this.camPos.z -= 180.0f * deltaTime;
        }
        if (Gdx.input.isKeyPressed(45)) {
            this.camPos.z += 180.0f * deltaTime;
        }
        perspCam.position.set(this.camPos);
        perspCam.update();
        Gdx.gl.glClear(16640);
        Renderer renderer = new Renderer(perspCam.combined);
        for (GameEntity e : this.entities) {
            e.update(deltaTime);
            e.draw(renderer);
            if (e.getState() == EntityState.Destroyed) {
                this.toRemove.addFirst(e);
            }
            if (!e.hasCreatedEntities()) continue;
            this.toAdd.addFirst(e.getCreatedEntities());
        }
        this.entities.removeAll(this.toRemove);
        Iterator iterator = this.toAdd.iterator();
        while (iterator.hasNext()) {
            GameEntity[] newEntities;
            GameEntity[] gameEntityArray = newEntities = (GameEntity[])iterator.next();
            int n = newEntities.length;
            int n2 = 0;
            while (n2 < n) {
                GameEntity e = gameEntityArray[n2];
                this.entities.add(e);
                ++n2;
            }
        }
        this.toAdd.clear();
        this.toRemove.clear();
        this.map.render(deltaTime, this.visibleArea, renderer);
    }

    @Override
    public void initialize() {
        this.camPos.set(CAM_INITIAL_POSITION);
    }

    @Override
    public GameState getState() {
        return GameState.Running;
    }
}

