/*
 * Decompiled with CFR 0.152.
 */
package com.me.mygdxgame.screens.entitytestscreen;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector3;
import com.me.mygdxgame.utilities.GameEntity;
import com.me.mygdxgame.utilities.GameMap;
import com.me.mygdxgame.utilities.GenericEntity;
import com.me.mygdxgame.utilities.Renderer;
import java.util.Arrays;

public class EntityTestMap
extends GameMap {
    private Rectangle[] obstacles = new Rectangle[]{new Rectangle(), new Rectangle(), new Rectangle(), new Rectangle()};
    public static float DEFAULT_THICKNESS = 10.0f;

    public EntityTestMap(float width, float height, float thickness) {
        this.obstacles[0].x = -width / 2.0f;
        this.obstacles[0].y = -height / 2.0f - thickness;
        this.obstacles[0].width = width;
        this.obstacles[0].height = thickness;
        this.obstacles[1].x = this.obstacles[0].x;
        this.obstacles[1].y = height / 2.0f;
        this.obstacles[1].width = width;
        this.obstacles[1].height = thickness;
        this.obstacles[2].x = this.obstacles[0].x - thickness;
        this.obstacles[2].y = this.obstacles[0].y + thickness;
        this.obstacles[2].width = thickness;
        this.obstacles[2].height = height;
        this.obstacles[3].x = -this.obstacles[0].x;
        this.obstacles[3].y = this.obstacles[2].y;
        this.obstacles[3].width = thickness;
        this.obstacles[3].height = height;
    }

    @Override
    public Vector3 getInitialPosition() {
        return new Vector3(0.0f, 0.0f, 0.0f);
    }

    @Override
    public GameEntity getObstacles() {
        return new GenericEntity(Arrays.asList(this.obstacles));
    }

    @Override
    public void render(float deltaTime, Rectangle visibleRegion, Renderer renderer) {
        GameMap.drawObstacles(renderer, this.obstacles, Color.RED);
    }

    @Override
    public void update(float deltaTime) {
    }
}

