/*
 * Decompiled with CFR 0.152.
 */
package com.me.mygdxgame.entities.projectiles;

import com.badlogic.gdx.audio.Sound;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector3;
import com.me.mygdxgame.entities.particles.Explosion;
import com.me.mygdxgame.entities.projectiles.BusterShot;
import com.me.mygdxgame.utilities.Damageable;
import com.me.mygdxgame.utilities.EntityState;
import com.me.mygdxgame.utilities.GameEntity;
import com.me.mygdxgame.utilities.Renderer;
import java.util.Collection;
import java.util.NoSuchElementException;

public class Hadouken
extends BusterShot {
    private static final int HADOUKEN_1_X = 211;
    private static final int HADOUKEN_1_Y = 211;
    private static final int HADOUKEN_1_W = 16;
    private static final int HADOUKEN_1_H = 19;
    private static final int HADOUKEN_2_X = 228;
    private static final int HADOUKEN_2_Y = 211;
    private static final int HADOUKEN_2_W = 19;
    private static final int HADOUKEN_2_H = 17;
    private static final float SFX_VOLUME = 0.5f;
    private static final float TIME_TO_FULLSIZE = 0.1f;
    private TextureRegion hadouken1;
    private TextureRegion hadouken2;
    private float fullSizeTimer = 0.1f;
    private boolean fullSize = false;
    private Sound explosion = null;
    private Explosion[] explosions;
    private boolean exploded = false;

    public Hadouken(Texture spriteSheet, Sound missSound, Sound explosion, Vector3 position, int speed, BusterShot.ShotDirection dir, int power, float range, Collection<GameEntity> obstacles, Collection<Damageable> targets) {
        super(spriteSheet, missSound, position, speed, dir, Math.max(9001, power), Math.max(1200.0f, range), obstacles, targets);
        this.hitBox = new Rectangle(position.x, position.y, 16.0f, 19.0f);
        this.hadouken1 = new TextureRegion(spriteSheet, 211, 211, 16, 19);
        this.hadouken2 = new TextureRegion(spriteSheet, 228, 211, 19, 17);
        if (dir == BusterShot.ShotDirection.LEFT) {
            this.hadouken1.flip(true, false);
            this.hadouken2.flip(true, false);
        }
        this.explosion = explosion;
    }

    @Override
    public void draw(Renderer renderer) {
        if (this.fullSize) {
            renderer.drawRegion(this.hadouken2, this.position.x, this.position.y);
        } else {
            renderer.drawRegion(this.hadouken1, this.position.x, this.position.y);
        }
    }

    @Override
    public void update(float deltaTime) {
        if (!this.fullSize) {
            this.fullSizeTimer = Math.max(0.0f, this.fullSizeTimer - deltaTime);
            if (this.fullSizeTimer == 0.0f) {
                this.fullSize = true;
                this.hitBox = new Rectangle(this.position.x, this.position.y, 19.0f, 17.0f);
                this.bullet = this.hadouken2;
                this.position.y += 2.0f;
            }
        }
        super.update(deltaTime);
        if (this.state == EntityState.Destroyed && !this.exploded) {
            this.explode();
        }
    }

    @Override
    public int getHeight() {
        if (this.fullSize) {
            return 17;
        }
        return 19;
    }

    @Override
    public int getWidth() {
        if (this.fullSize) {
            return 19;
        }
        return 16;
    }

    @Override
    public void setShotColor(Color shotColor) {
    }

    @Override
    public void setShotScale(float shotScale) {
    }

    private void explode() {
        if (!this.exploded) {
            this.position.x += 9.0f;
            this.position.y += 8.0f;
            this.explosions = new Explosion[4];
            this.explosions[0] = new Explosion(this.spriteSheet, new Vector3(this.position.x + 12.0f, this.position.y + 12.0f, this.position.z));
            this.explosions[1] = new Explosion(this.spriteSheet, new Vector3(this.position.x - 12.0f, this.position.y + 12.0f, this.position.z));
            this.explosions[2] = new Explosion(this.spriteSheet, new Vector3(this.position.x + 12.0f, this.position.y - 12.0f, this.position.z));
            this.explosions[3] = new Explosion(this.spriteSheet, new Vector3(this.position.x - 12.0f, this.position.y - 12.0f, this.position.z));
            this.explosion.stop();
            this.explosion.play(0.5f);
            this.exploded = true;
        }
    }

    @Override
    public boolean hasCreatedEntities() {
        return this.explosions != null;
    }

    @Override
    public GameEntity[] getCreatedEntities() throws NoSuchElementException {
        if (this.explosions == null) {
            throw new NoSuchElementException();
        }
        GameEntity[] returnList = this.explosions;
        this.explosions = null;
        return returnList;
    }
}

