/*
 * Decompiled with CFR 0.152.
 */
package com.me.mygdxgame.entities.projectiles;

import com.badlogic.gdx.audio.Sound;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector3;
import com.me.mygdxgame.entities.projectiles.BusterShot;
import com.me.mygdxgame.utilities.Damageable;
import com.me.mygdxgame.utilities.EntityState;
import com.me.mygdxgame.utilities.GameEntity;
import java.util.Collection;

public class GeminiShot
extends BusterShot {
    private static final int GEMINI_W = 7;
    private static final int GEMINI_H = 5;
    private static final int MAX_SHOTS = 6;
    private static int currentShots = 0;
    public static final int MAX_DEFLECTS = 6;
    private boolean isDeflected;
    private ShotDeflection dir2;
    private int numDeflects;

    public GeminiShot(Texture spriteSheet, Sound missSound, Vector3 position, int speed, BusterShot.ShotDirection dir, int power, float range, Collection<GameEntity> obstacles, Collection<Damageable> targets) {
        super(spriteSheet, missSound, position, speed, dir, 2 * power, 3.0f * range, obstacles, targets);
        int regionWidth = this.bullet.getRegionWidth();
        this.bullet.setRegionX(this.bullet.getRegionX() + this.bullet.getRegionWidth());
        this.bullet.setRegionWidth(regionWidth);
        if (++currentShots >= 6) {
            this.destroy();
        }
        this.isDeflected = false;
        this.numDeflects = 0;
    }

    public GeminiShot(BusterShot shot) {
        this(shot.spriteSheet, shot.missSound, shot.position, shot.speed, shot.dir, shot.power, shot.range, shot.obstacles, shot.targets);
        this.setShotScale(shot.getShotScale());
    }

    @Override
    public void update(float deltaTime) {
        if (this.state == EntityState.Running) {
            float toTravel = (float)this.speed * deltaTime;
            this.distanceTraveled += toTravel;
            if (this.distanceTraveled >= this.range) {
                this.state = EntityState.Destroyed;
                --currentShots;
                return;
            }
            this.position.x = this.dir == BusterShot.ShotDirection.LEFT ? (this.position.x -= toTravel) : (this.position.x += toTravel);
            this.hitBox.x = this.position.x;
            this.hitBox.y = this.position.y;
            this.checkObstacleCollisionsX();
            if (this.isDeflected) {
                this.position.y = this.dir2 == ShotDeflection.UP ? (this.position.y += toTravel) : (this.position.y -= toTravel);
                this.hitBox.x = this.position.x;
                this.hitBox.y = this.position.y;
                this.checkObstacleCollisionsY();
            }
            this.hitBox.x = this.position.x;
            this.hitBox.y = this.position.y;
            for (Damageable target : this.targets) {
                Rectangle[] hitAreas;
                Rectangle[] rectangleArray = hitAreas = target.getHitArea();
                int n = hitAreas.length;
                int n2 = 0;
                while (n2 < n) {
                    Rectangle hitBox = rectangleArray[n2];
                    if (hitBox.overlaps(this.hitBox)) {
                        target.damage(this);
                        this.state = EntityState.Destroyed;
                        --currentShots;
                        return;
                    }
                    ++n2;
                }
            }
        }
    }

    private void checkObstacleCollisionsX() {
        if (this.numDeflects >= 6) {
            return;
        }
        for (GameEntity entity : this.obstacles) {
            Rectangle[] rectangleArray = entity.getHitArea();
            int n = rectangleArray.length;
            int n2 = 0;
            while (n2 < n) {
                Rectangle r = rectangleArray[n2];
                if (r.overlaps(this.hitBox)) {
                    ++this.numDeflects;
                    if (this.dir == BusterShot.ShotDirection.LEFT) {
                        this.dir = BusterShot.ShotDirection.RIGHT;
                        this.position.x = r.getX() + r.getWidth() + 1.0f;
                    } else {
                        this.dir = BusterShot.ShotDirection.LEFT;
                        this.position.x = r.getX() - 7.0f - 1.0f;
                    }
                    if (!this.isDeflected) {
                        this.isDeflected = true;
                        this.dir2 = ShotDeflection.UP;
                        this.dir = this.dir == BusterShot.ShotDirection.LEFT ? BusterShot.ShotDirection.RIGHT : BusterShot.ShotDirection.LEFT;
                    }
                    return;
                }
                ++n2;
            }
        }
    }

    private void checkObstacleCollisionsY() {
        if (this.numDeflects >= 6) {
            return;
        }
        for (GameEntity entity : this.obstacles) {
            Rectangle[] rectangleArray = entity.getHitArea();
            int n = rectangleArray.length;
            int n2 = 0;
            while (n2 < n) {
                Rectangle r = rectangleArray[n2];
                if (r.overlaps(this.hitBox)) {
                    ++this.numDeflects;
                    if (this.dir2 == ShotDeflection.UP) {
                        this.dir2 = ShotDeflection.DOWN;
                        this.position.y = r.getY() - 5.0f - 1.0f;
                    } else {
                        this.dir2 = ShotDeflection.UP;
                        this.position.y = r.getY() + r.getHeight() + 1.0f;
                    }
                    return;
                }
                ++n2;
            }
        }
    }

    @Override
    public void destroy() {
        if (this.state == EntityState.Running) {
            this.state = EntityState.Destroyed;
            --currentShots;
        }
    }

    public static enum ShotDeflection {
        UP,
        DOWN;

    }
}

