/*
 * Decompiled with CFR 0.152.
 */
package com.me.mygdxgame.entities.projectiles;

import com.badlogic.gdx.audio.Sound;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector3;
import com.me.mygdxgame.utilities.Damageable;
import com.me.mygdxgame.utilities.Damager;
import com.me.mygdxgame.utilities.EntityState;
import com.me.mygdxgame.utilities.GameEntity;
import com.me.mygdxgame.utilities.Renderer;
import java.util.Collection;
import java.util.NoSuchElementException;

public class BusterShot
implements GameEntity,
Damager {
    protected static final int BULLET_X = 226;
    protected static final int BULLET_Y = 175;
    protected static final int BULLET_W = 7;
    protected static final int BULLET_H = 5;
    protected TextureRegion bullet;
    protected float animationTimer = 0.0f;
    protected Texture spriteSheet = null;
    protected Sound missSound = null;
    protected ShotDirection dir;
    protected Vector3 position = new Vector3(0.0f, 0.0f, 0.0f);
    protected int speed = 0;
    protected int power = 0;
    protected float range = 0.0f;
    protected float distanceTraveled = 0.0f;
    protected Rectangle hitBox = new Rectangle(0.0f, 0.0f, 7.0f, 5.0f);
    protected Rectangle[] hitAreas = new Rectangle[]{this.hitBox};
    protected EntityState state;
    private Color shotColor = Color.WHITE;
    private float shotScale = 1.0f;
    protected Collection<GameEntity> obstacles;
    protected Collection<Damageable> targets;

    public BusterShot(Texture spriteSheet, Sound missSound, Vector3 position, int speed, ShotDirection dir, int power, float range, Collection<GameEntity> obstacles, Collection<Damageable> targets) {
        this.spriteSheet = spriteSheet;
        this.missSound = missSound;
        this.position.set(position);
        this.speed = speed;
        this.dir = dir;
        this.range = range;
        this.power = power;
        this.bullet = new TextureRegion(this.spriteSheet, 226, 175, 7, 5);
        this.obstacles = obstacles;
        this.targets = targets;
        this.state = EntityState.Running;
    }

    @Override
    public void update(float deltaTime) {
        if (this.state == EntityState.Running) {
            int n;
            int n2;
            Rectangle[] rectangleArray;
            float toTravel = (float)this.speed * deltaTime;
            this.position.x = this.dir == ShotDirection.LEFT ? (this.position.x -= toTravel) : (this.position.x += toTravel);
            this.distanceTraveled += toTravel;
            if (this.distanceTraveled >= this.range) {
                this.state = EntityState.Destroyed;
                this.missSound.stop();
                this.missSound.play();
                return;
            }
            this.hitBox.x = this.position.x;
            this.hitBox.y = this.position.y;
            for (Damageable target : this.targets) {
                rectangleArray = target.getHitArea();
                n2 = rectangleArray.length;
                n = 0;
                while (n < n2) {
                    Rectangle hitBox = rectangleArray[n];
                    if (hitBox.overlaps(this.hitBox)) {
                        target.damage(this);
                        this.state = EntityState.Destroyed;
                        return;
                    }
                    ++n;
                }
            }
            for (GameEntity entity : this.obstacles) {
                rectangleArray = entity.getHitArea();
                n2 = rectangleArray.length;
                n = 0;
                while (n < n2) {
                    Rectangle r = rectangleArray[n];
                    if (r.overlaps(this.hitBox)) {
                        this.state = EntityState.Destroyed;
                        this.missSound.play();
                        return;
                    }
                    ++n;
                }
            }
            this.animationTimer += deltaTime;
        }
    }

    @Override
    public void draw(Renderer renderer) {
        if (this.state == EntityState.Running) {
            renderer.drawRegion(this.bullet, this.position.x, this.position.y, this.shotColor, this.shotScale, this.shotScale, (int)(300.0f * this.animationTimer));
        }
    }

    @Override
    public EntityState getState() {
        return this.state;
    }

    @Override
    public boolean hasCreatedEntities() {
        return false;
    }

    @Override
    public GameEntity[] getCreatedEntities() throws NoSuchElementException {
        throw new NoSuchElementException();
    }

    @Override
    public Rectangle[] getHitArea() {
        return this.hitAreas;
    }

    @Override
    public void destroy() {
        this.state = EntityState.Destroyed;
    }

    @Override
    public Vector3 getPosition() {
        return new Vector3(this.position);
    }

    @Override
    public int getWidth() {
        return 7;
    }

    @Override
    public int getHeight() {
        return 5;
    }

    @Override
    public int getPower() {
        return this.power;
    }

    @Override
    public int getKnockback() {
        return 0;
    }

    public Color getShotColor() {
        return this.shotColor;
    }

    public void setShotColor(Color shotColor) {
        this.shotColor = shotColor;
    }

    public float getShotScale() {
        return this.shotScale;
    }

    public void setShotScale(float shotScale) {
        this.shotScale = shotScale;
    }

    public static enum ShotDirection {
        LEFT,
        RIGHT;

    }
}

