/*
 * Decompiled with CFR 0.152.
 */
package com.me.mygdxgame.entities.obstacles;

import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector3;
import com.me.mygdxgame.entities.projectiles.FatRubble;
import com.me.mygdxgame.entities.projectiles.Rubble;
import com.me.mygdxgame.entities.projectiles.SmallRubble;
import com.me.mygdxgame.entities.projectiles.TallRubble;
import com.me.mygdxgame.screens.seeteufelscreen.SeeteufelScreen;
import com.me.mygdxgame.utilities.Damageable;
import com.me.mygdxgame.utilities.Damager;
import com.me.mygdxgame.utilities.EntityState;
import com.me.mygdxgame.utilities.GameEntity;
import com.me.mygdxgame.utilities.Renderer;
import java.util.NoSuchElementException;

public class Platform
implements Damageable {
    protected static final int PLATFORM_X = 0;
    protected static final int PLATFORM_Y = 0;
    protected static final int PLATFORM_W = 32;
    protected static final int PLATFORM_H = 32;
    protected static final int MAX_HEALTH = 1;
    protected Texture spriteSheet;
    protected TextureRegion platform;
    protected EntityState status;
    protected int x;
    protected int y;
    protected int health;
    protected Rectangle hitbox;
    protected Rubble[] rubble = null;
    private Rectangle[] hitArea = new Rectangle[1];
    protected static final int RUBBLE_LIFE = 500;

    public Platform(Texture spriteSheet, SeeteufelScreen.MapTiles tiles, int x, int y) {
        this.spriteSheet = spriteSheet;
        this.platform = new TextureRegion(tiles.rockTex, 0, 0, 32, 32);
        this.status = EntityState.Running;
        this.x = x;
        this.y = y;
        this.hitbox = new Rectangle((float)this.x, (float)this.y, 32.0f, 32.0f);
        this.health = 1;
        this.hitArea[0] = this.hitbox;
    }

    @Override
    public void update(float deltaTime) {
        if (this.status == EntityState.Running && this.health <= 0) {
            this.explode();
            this.status = EntityState.Destroyed;
        }
    }

    @Override
    public void draw(Renderer renderer) {
        if (this.status == EntityState.Running) {
            renderer.drawRegion(this.platform, this.x, this.y);
        }
    }

    @Override
    public EntityState getState() {
        return this.status;
    }

    @Override
    public boolean hasCreatedEntities() {
        return this.rubble != null && this.rubble.length > 0;
    }

    @Override
    public GameEntity[] getCreatedEntities() throws NoSuchElementException {
        if (this.rubble == null || this.rubble.length <= 0) {
            throw new NoSuchElementException();
        }
        GameEntity[] returnList = this.rubble;
        this.rubble = null;
        return returnList;
    }

    @Override
    public void damage(Damager damager) {
        this.health -= damager.getPower();
    }

    @Override
    public int getHealth() {
        return this.health;
    }

    @Override
    public int getMaxHealth() {
        return 1;
    }

    @Override
    public Rectangle[] getHitArea() {
        return this.hitArea;
    }

    protected void explode() {
        this.rubble = new Rubble[]{new FatRubble(this.spriteSheet, new Vector3((float)(this.x - 5), (float)(this.y + 5), 0.0f), new Vector3((100.0f + (float)Math.random() * 50.0f) * (float)Math.signum(Math.random() - 0.5), (float)Math.random() * 300.0f, 0.0f), 5, new GameEntity[0], new Damageable[0], 0.5f), new SmallRubble(this.spriteSheet, new Vector3((float)(this.x + 10), (float)(this.y + 15), 0.0f), new Vector3((100.0f + (float)Math.random() * 50.0f) * (float)Math.signum(Math.random() - 0.5), (float)Math.random() * 300.0f, 0.0f), 5, new GameEntity[0], new Damageable[0], 0.5f), new TallRubble(this.spriteSheet, new Vector3((float)(this.x + 0), (float)(this.y + 10), 0.0f), new Vector3((100.0f + (float)Math.random() * 50.0f) * (float)Math.signum(Math.random() - 0.5), (float)Math.random() * 300.0f, 0.0f), 5, new GameEntity[0], new Damageable[0], 0.5f), new FatRubble(this.spriteSheet, new Vector3((float)(this.x - 5), (float)(this.y + 5), 0.0f), new Vector3((100.0f + (float)Math.random() * 50.0f) * (float)Math.signum(Math.random() - 0.5), (float)Math.random() * 300.0f, 0.0f), 5, new GameEntity[0], new Damageable[0], 0.5f)};
    }

    @Override
    public void destroy() {
        this.status = EntityState.Destroyed;
    }

    @Override
    public Vector3 getPosition() {
        return new Vector3((float)this.x, (float)this.y, 0.0f);
    }

    @Override
    public int getWidth() {
        return 32;
    }

    @Override
    public int getHeight() {
        return 32;
    }
}

