/*
 * Decompiled with CFR 0.152.
 */
package com.me.mygdxgame.entities;

import com.badlogic.gdx.audio.Sound;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector3;
import com.me.mygdxgame.utilities.EntityState;
import com.me.mygdxgame.utilities.GameEntity;
import com.me.mygdxgame.utilities.Renderer;
import java.util.NoSuchElementException;

public class Refractor
implements GameEntity {
    public static final int REFRACTOR_X = 136;
    public static final int REFRACTOR_Y = 210;
    public static final int REFRACTOR_W = 18;
    public static final int REFRACTOR_H = 46;
    public static final Color BOX_COLOR = new Color(0.0f, 0.0f, 1.0f, 0.35f);
    public static final Color LINE_COLOR = new Color(1.0f, 1.0f, 1.0f, 0.5f);
    public static final CharSequence MESG = "YOU GOT BLUE REFRACTOR";
    private EntityState status;
    private TextureRegion refractor;
    private boolean taken;
    private static final float MESG_DELAY = 1.5f;
    private float mesgDuration;
    private Sound itemGetSound = null;
    private BitmapFont font = null;
    private Rectangle hitbox = null;
    private Rectangle[] allHitAreas = null;

    public Refractor(Texture spriteSheet, Sound getSound, BitmapFont font, int x, int y) {
        this.hitbox = new Rectangle((float)x, (float)y, 18.0f, 46.0f);
        this.allHitAreas = new Rectangle[]{this.hitbox};
        this.itemGetSound = getSound;
        this.font = font;
        this.refractor = new TextureRegion(spriteSheet, 136, 210, 18, 46);
        this.taken = false;
        this.status = EntityState.Running;
        this.mesgDuration = 0.0f;
    }

    @Override
    public void update(float deltaTime) {
        if (this.status == EntityState.Running && this.taken) {
            if (this.mesgDuration < 1.5f) {
                this.mesgDuration += deltaTime;
            } else {
                this.status = EntityState.Destroyed;
            }
        }
    }

    @Override
    public void draw(Renderer renderer) {
        if (this.status == EntityState.Running && !this.taken) {
            renderer.drawRegion(this.refractor, this.hitbox.x, this.hitbox.y);
        } else if (this.taken && this.mesgDuration < 1.5f) {
            float posX = this.hitbox.x - (float)((MESG.length() + 2) / 2 * 8);
            float posY = this.hitbox.y + 46.0f + 16.0f;
            float width = (MESG.length() + 5) * 8;
            float height = 24.0f;
            renderer.drawRect(ShapeRenderer.ShapeType.Filled, BOX_COLOR, posX, posY, width, height);
            renderer.drawRect(ShapeRenderer.ShapeType.Line, LINE_COLOR, posX, posY, width, height);
            renderer.drawText(this.font, MESG, this.hitbox.x - (float)(MESG.length() / 2 * 8), this.hitbox.y + 46.0f + 32.0f);
        }
    }

    @Override
    public EntityState getState() {
        return this.status;
    }

    @Override
    public boolean hasCreatedEntities() {
        return false;
    }

    @Override
    public GameEntity[] getCreatedEntities() throws NoSuchElementException {
        throw new NoSuchElementException("No elements to return.");
    }

    public void onTake() {
        if (!this.taken) {
            this.itemGetSound.play(0.5f);
            this.taken = true;
        }
    }

    @Override
    public Rectangle[] getHitArea() {
        return this.allHitAreas;
    }

    @Override
    public void destroy() {
        this.status = EntityState.Destroyed;
    }

    @Override
    public Vector3 getPosition() {
        return new Vector3(this.hitbox.x, this.hitbox.y, 0.0f);
    }

    @Override
    public int getWidth() {
        return 18;
    }

    @Override
    public int getHeight() {
        return 46;
    }
}

