/*
 * Decompiled with CFR 0.152.
 */
package com.me.mygdxgame.entities;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.audio.Sound;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector3;
import com.me.mygdxgame.armor.NormalJacket;
import com.me.mygdxgame.buster.GeminiBuster;
import com.me.mygdxgame.buster.MegaBuster;
import com.me.mygdxgame.combo.HadoukenComboLeft;
import com.me.mygdxgame.combo.HadoukenComboRight;
import com.me.mygdxgame.entities.particles.Splash;
import com.me.mygdxgame.entities.projectiles.BusterShot;
import com.me.mygdxgame.entities.projectiles.Hadouken;
import com.me.mygdxgame.utilities.ArmorJacket;
import com.me.mygdxgame.utilities.BusterPart;
import com.me.mygdxgame.utilities.Damageable;
import com.me.mygdxgame.utilities.Damager;
import com.me.mygdxgame.utilities.EntityState;
import com.me.mygdxgame.utilities.GameEntity;
import com.me.mygdxgame.utilities.Renderer;
import com.me.mygdxgame.utilities.SpecialCombo;
import com.me.mygdxgame.utilities.SpecialComboListener;
import java.util.Collection;
import java.util.LinkedList;
import java.util.NoSuchElementException;

public class MegaPlayer
implements GameEntity,
Damageable {
    private static final int MAX_HEALTH = 100;
    public static final int HITBOX_WIDTH = 28;
    public static final int HITBOX_HEIGHT = 32;
    private static final int SPRITE_WIDTH = 38;
    private static final int SPRITE_HEIGHT = 45;
    private static final int HITBOX_OFFSET_X = 5;
    private static final int HITBOX_OFFSET_Y = 5;
    private static final float MAX_FLINCH_TIME = 0.3f;
    private static final float FLINCH_ANIMATION_THRESHOLD = 0.3f;
    public static final float MAX_SPEED = 250.0f;
    private static final float MAX_JUMP_SPEED = 300.0f;
    private static final float MAX_FALL_SPEED = 600.0f;
    private static final float MAX_UNDERWATER_FALL_SPEED = 250.0f;
    private static final float MAX_JUMP_THRUST_TIME = 0.225f;
    private static final float ACCELERATION = 1900.0f;
    private static final float DECELERATION = 1300.0f;
    private static final float GRAVITY = 1600.0f;
    private static final float RUN_FRAMERATE = 0.175f;
    private static final short MAX_RUN_FRAMES = 4;
    private static final float SHOT_OFFSET_Y = 16.0f;
    private static final float SHOT_OFFSET_X = 16.0f;
    private static final float WATER_MOVEMENT_FACTOR = 1.5f;
    private static final float SFX_VOLUME = 0.5f;
    private Vector3 position = new Vector3();
    private Vector3 velocity = new Vector3();
    private Vector3 shotOrigin = new Vector3();
    private MegaBuster busterGun;
    private MegaBuster tempBuster;
    private ArmorJacket armor;
    private BusterShot tempShot;
    private int health = 100;
    private Collection<GameEntity> obstacles = null;
    private Collection<Damageable> targets = null;
    private Rectangle hitBox = new Rectangle(0.0f, 0.0f, 28.0f, 32.0f);
    private Rectangle[] hitAreas = new Rectangle[]{this.hitBox};
    private float animationTimer = 0.0f;
    private int prevFrame = 0;
    private boolean isInAir = false;
    private boolean isJumping = false;
    private boolean canJump = true;
    private float flinchTimer = 0.0f;
    private float jumpThrustTimer = 0.0f;
    private float appliedVerticalDelta = 0.0f;
    private boolean isFacingRight = false;
    private boolean geminiEnabled = false;
    private boolean jumpSpringsEnabled = false;
    private boolean isUnderwater = false;
    private SpecialComboListener megaComboEngine;
    private boolean hadoukenEnabled = false;
    private boolean isHadoukening = false;
    private TextureRegion[] hadoukenLeft = new TextureRegion[3];
    private TextureRegion[] hadoukenRight = new TextureRegion[3];
    private float hadoukenTimer = 0.0f;
    private static final float HADOUKEN_STARTUP_DELAY = 0.6f;
    private static final int HADOUKEN_OFFSET_Y = 8;
    private Texture spritesheet = null;
    MegaPlayerResources resources = new MegaPlayerResources();
    private TextureRegion[] runRight = new TextureRegion[4];
    private TextureRegion[] runLeft = new TextureRegion[4];
    private TextureRegion[] runShootRight = new TextureRegion[4];
    private TextureRegion[] runShootLeft = new TextureRegion[4];
    private TextureRegion standRight = null;
    private TextureRegion standLeft = null;
    private TextureRegion standShootRight = null;
    private TextureRegion standShootLeft = null;
    private TextureRegion[] damageRight = new TextureRegion[2];
    private TextureRegion[] damageLeft = new TextureRegion[2];
    private TextureRegion[] jumpLeft = new TextureRegion[2];
    private TextureRegion[] jumpRight = new TextureRegion[2];
    private TextureRegion[] jumpShootLeft = new TextureRegion[2];
    private TextureRegion[] jumpShootRight = new TextureRegion[2];
    private TextureRegion currentFrame = null;
    private LinkedList<GameEntity> createdEntities = new LinkedList();

    public MegaPlayer(Texture spritesheet, MegaPlayerResources resources, Vector3 initialPosition, Collection<GameEntity> obstacles, Collection<Damageable> targets) {
        this.spritesheet = spritesheet;
        this.resources = resources;
        this.position.set(initialPosition);
        this.obstacles = obstacles;
        this.targets = targets;
        this.busterGun = new MegaBuster(spritesheet, this.resources.shootSound, this.resources.shotMissSound);
        this.armor = new NormalJacket();
        this.geminiEnabled = false;
        this.megaComboEngine = new SpecialComboListener();
        this.megaComboEngine.addCombo(new HadoukenComboRight());
        this.megaComboEngine.addCombo(new HadoukenComboLeft());
        this.runRight[0] = new TextureRegion(spritesheet, 0, 256, 38, 45);
        this.runRight[1] = new TextureRegion(spritesheet, this.runRight[0].getRegionX() + 38, 256, 38, 45);
        this.runRight[2] = new TextureRegion(spritesheet, this.runRight[1].getRegionX() + 38, 256, 38, 45);
        this.runRight[3] = new TextureRegion(spritesheet, this.runRight[2].getRegionX() + 38, 256, 38, 45);
        this.runLeft[0] = new TextureRegion(this.runRight[0]);
        this.runLeft[0].flip(true, false);
        this.runLeft[1] = new TextureRegion(this.runRight[1]);
        this.runLeft[1].flip(true, false);
        this.runLeft[2] = new TextureRegion(this.runRight[2]);
        this.runLeft[2].flip(true, false);
        this.runLeft[3] = new TextureRegion(this.runRight[3]);
        this.runLeft[3].flip(true, false);
        this.runShootRight[0] = new TextureRegion(spritesheet, 0, 302, 38, 45);
        this.runShootRight[1] = new TextureRegion(spritesheet, this.runRight[1].getRegionX(), this.runShootRight[0].getRegionY(), 38, 45);
        this.runShootRight[2] = new TextureRegion(spritesheet, this.runRight[2].getRegionX(), this.runShootRight[0].getRegionY(), 38, 45);
        this.runShootRight[3] = new TextureRegion(spritesheet, this.runRight[3].getRegionX(), this.runShootRight[0].getRegionY(), 38, 45);
        this.runShootLeft[0] = new TextureRegion(this.runShootRight[0]);
        this.runShootLeft[0].flip(true, false);
        this.runShootLeft[1] = new TextureRegion(this.runShootRight[1]);
        this.runShootLeft[1].flip(true, false);
        this.runShootLeft[2] = new TextureRegion(this.runShootRight[2]);
        this.runShootLeft[2].flip(true, false);
        this.runShootLeft[3] = new TextureRegion(this.runShootRight[3]);
        this.runShootLeft[3].flip(true, false);
        this.standRight = new TextureRegion(spritesheet, 0, this.runShootRight[0].getRegionY() + 45, 38, 45);
        this.standLeft = new TextureRegion(this.standRight);
        this.standLeft.flip(true, false);
        this.standShootRight = new TextureRegion(spritesheet, this.runShootRight[1].getRegionX(), this.standRight.getRegionY(), 38, 45);
        this.standShootLeft = new TextureRegion(this.standShootRight);
        this.standShootLeft.flip(true, false);
        this.damageRight[0] = new TextureRegion(spritesheet, this.runShootRight[2].getRegionX(), this.standShootRight.getRegionY(), 38, 45);
        this.damageRight[1] = new TextureRegion(spritesheet, this.runShootRight[3].getRegionX(), this.standShootRight.getRegionY(), 38, 45);
        this.damageLeft[0] = new TextureRegion(this.damageRight[0]);
        this.damageLeft[0].flip(true, false);
        this.damageLeft[1] = new TextureRegion(this.damageRight[1]);
        this.damageLeft[1].flip(true, false);
        this.jumpRight[0] = new TextureRegion(spritesheet, this.runRight[0].getRegionX(), this.standRight.getRegionY() + 45, 38, 45);
        this.jumpRight[1] = new TextureRegion(spritesheet, this.runRight[2].getRegionX(), this.jumpRight[0].getRegionY(), 38, 45);
        this.jumpLeft[0] = new TextureRegion(this.jumpRight[0]);
        this.jumpLeft[0].flip(true, false);
        this.jumpLeft[1] = new TextureRegion(this.jumpRight[1]);
        this.jumpLeft[1].flip(true, false);
        this.jumpShootRight[0] = new TextureRegion(spritesheet, this.runRight[1].getRegionX(), this.standRight.getRegionY() + 45, 38, 45);
        this.jumpShootRight[1] = new TextureRegion(spritesheet, this.runRight[3].getRegionX(), this.standRight.getRegionY() + 45, 38, 45);
        this.jumpShootLeft[0] = new TextureRegion(this.jumpShootRight[0]);
        this.jumpShootLeft[0].flip(true, false);
        this.jumpShootLeft[1] = new TextureRegion(this.jumpShootRight[1]);
        this.jumpShootLeft[1].flip(true, false);
        this.hadoukenRight[0] = new TextureRegion(spritesheet, 152, 347, 38, 45);
        this.hadoukenRight[1] = new TextureRegion(spritesheet, 152, 302, 38, 45);
        this.hadoukenRight[2] = new TextureRegion(spritesheet, 152, 256, 38, 45);
        this.hadoukenLeft[0] = new TextureRegion(this.hadoukenRight[0]);
        this.hadoukenLeft[0].flip(true, false);
        this.hadoukenLeft[1] = new TextureRegion(this.hadoukenRight[1]);
        this.hadoukenLeft[1].flip(true, false);
        this.hadoukenLeft[2] = new TextureRegion(this.hadoukenRight[2]);
        this.hadoukenLeft[2].flip(true, false);
        this.currentFrame = this.standLeft;
    }

    public void setPosition(Vector3 position) {
        this.position.set(position);
    }

    public void setGeminiEnabled(boolean geminiEnabled) {
        this.geminiEnabled = geminiEnabled;
        this.tempBuster = geminiEnabled ? new GeminiBuster(this.spritesheet, this.resources.geminiSound, this.resources.shotMissSound) : new MegaBuster(this.spritesheet, this.resources.shootSound, this.resources.shotMissSound);
        for (BusterPart bp : this.busterGun.getAttachments()) {
            this.tempBuster.attachBusterPart(bp);
        }
        this.busterGun = this.tempBuster;
    }

    public boolean isGeminiEnabled() {
        return this.geminiEnabled;
    }

    public void setHadoukenEnabled(boolean hadoukenEnabled) {
        this.hadoukenEnabled = hadoukenEnabled;
    }

    public boolean isHadoukenEnabled() {
        return this.hadoukenEnabled;
    }

    private void fireHadouken() {
        this.resources.hadoukenSound.play(0.5f);
        this.shotOrigin.set(this.position);
        this.shotOrigin.y += 8.0f;
        BusterShot.ShotDirection shotDir = BusterShot.ShotDirection.LEFT;
        if (this.isFacingRight) {
            this.shotOrigin.x = (float)((double)this.shotOrigin.x + 24.0);
            shotDir = BusterShot.ShotDirection.RIGHT;
        }
        this.tempShot = new Hadouken(this.spritesheet, this.resources.shotMissSound, this.resources.explodeSound, this.shotOrigin, 300, shotDir, 1, 1.0f, this.obstacles, this.targets);
        this.createdEntities.offer(this.tempShot);
    }

    public SpecialComboListener getComboListener() {
        return this.megaComboEngine;
    }

    public void setJumpSpringsEnabled(boolean jumpSpringsEnabled) {
        this.jumpSpringsEnabled = jumpSpringsEnabled;
    }

    public boolean isJumpSpringsEnabled() {
        return this.jumpSpringsEnabled;
    }

    private float computeJumpThrustLimit() {
        return 0.225f * (this.jumpSpringsEnabled ? 1.2f : 1.0f);
    }

    public MegaBuster getMegaBuster() {
        return this.busterGun;
    }

    public ArmorJacket getArmor() {
        return this.armor;
    }

    public void setArmor(ArmorJacket jacket) {
        this.armor = jacket;
    }

    @Override
    public Vector3 getPosition() {
        return new Vector3(this.position.x, this.position.y, this.position.z);
    }

    public void setIsUnderwater(boolean isUnderwater, boolean createSplash) {
        if (createSplash && this.isUnderwater != isUnderwater) {
            float adjustedX = this.position.x + 19.0f;
            int x = 0;
            while (x < 5) {
                this.createdEntities.add(new Splash(adjustedX, this.position.y));
                ++x;
            }
        }
        this.isUnderwater = isUnderwater;
    }

    public boolean getIsUnderwater() {
        return this.isUnderwater;
    }

    public boolean getIsInAir() {
        return this.isInAir;
    }

    @Override
    public void damage(Damager damager) {
        if (this.flinchTimer <= 0.0f) {
            this.resources.hurtSound.play(0.5f);
            int damage = damager.getPower();
            damage = (int)Math.min((float)damage, (float)damage * this.armor.getDefenseFactor());
            this.health -= damage;
            this.health = Math.max(this.health, 0);
            this.health = Math.min(this.health, 100);
            this.flinchTimer = 0.3f;
            this.isJumping = false;
            Vector3 damagerPos = damager.getPosition();
            damagerPos.x = (float)((double)damagerPos.x + (double)damager.getWidth() / 2.0);
            damagerPos.y = (float)((double)damagerPos.y + (double)damager.getHeight() / 2.0);
            this.velocity.add(new Vector3(this.position.x - damagerPos.x, this.position.y - damagerPos.y, 0.0f).nor().scl((float)damager.getKnockback()));
        }
    }

    @Override
    public int getHealth() {
        return this.health;
    }

    @Override
    public int getMaxHealth() {
        return 100;
    }

    @Override
    public Rectangle[] getHitArea() {
        return this.hitAreas;
    }

    @Override
    public void update(float deltaTime) {
        this.megaComboEngine.updateComboTimer(deltaTime);
        SpecialCombo match = this.megaComboEngine.getMatchedCombo();
        if (this.hadoukenEnabled && !this.isHadoukening && !this.isInAir && this.getHealth() >= this.getMaxHealth() && match != null && (this.isFacingRight && match.equals(new HadoukenComboRight()) || !this.isFacingRight && match.equals(new HadoukenComboLeft()))) {
            this.isHadoukening = true;
            this.hadoukenTimer = 0.6f;
        }
        if (this.flinchTimer == 0.0f) {
            if (!this.isHadoukening) {
                this.handleInput(deltaTime);
            } else if (this.hadoukenTimer == 0.0f) {
                this.fireHadouken();
                this.isHadoukening = false;
            } else {
                this.hadoukenTimer = Math.max(this.hadoukenTimer - deltaTime, 0.0f);
            }
        } else {
            this.flinchTimer = Math.max(this.flinchTimer - deltaTime, 0.0f);
        }
        this.appliedVerticalDelta = deltaTime;
        float totalMovement = this.velocity.y * deltaTime;
        float movementStep = 16.0f;
        if (totalMovement > 0.0f) {
            do {
                this.position.y += Math.min(totalMovement, movementStep);
            } while (!this.checkCollisionsY() && (totalMovement -= movementStep) > 0.0f);
        } else {
            do {
                this.position.y += Math.max(totalMovement, -movementStep);
            } while (!this.checkCollisionsY() && (totalMovement += movementStep) < 0.0f);
        }
        totalMovement = this.velocity.x * deltaTime;
        movementStep = 14.0f;
        if (totalMovement > 0.0f) {
            do {
                if (this.isUnderwater) {
                    this.position.x += Math.min(totalMovement / 1.5f, movementStep);
                    totalMovement -= movementStep;
                    continue;
                }
                this.position.x += Math.min(totalMovement, movementStep);
                totalMovement -= movementStep;
            } while (!this.checkCollionsX() && totalMovement > 0.0f);
        } else {
            do {
                if (this.isUnderwater) {
                    this.position.x += Math.max(totalMovement / 1.5f, -movementStep);
                    totalMovement += movementStep;
                    continue;
                }
                this.position.x += Math.max(totalMovement, -movementStep);
                totalMovement += movementStep;
            } while (!this.checkCollionsX() && totalMovement < 0.0f);
        }
        this.handlePhysics(deltaTime);
        this.determineFrame(deltaTime);
    }

    @Override
    public void draw(Renderer renderer) {
        float drawPositionX = this.position.x - 5.0f;
        float drawPositionY = this.position.y - 5.0f;
        renderer.drawRegion(this.currentFrame, drawPositionX, drawPositionY);
    }

    @Override
    public EntityState getState() {
        if (this.health > 0) {
            return EntityState.Running;
        }
        return EntityState.Destroyed;
    }

    @Override
    public boolean hasCreatedEntities() {
        return !this.createdEntities.isEmpty();
    }

    @Override
    public GameEntity[] getCreatedEntities() throws NoSuchElementException {
        GameEntity[] returnList = new GameEntity[this.createdEntities.size()];
        this.createdEntities.toArray(returnList);
        this.createdEntities.clear();
        return returnList;
    }

    private void determineFrame(float deltaTime) {
        if (this.isFacingRight) {
            if (this.flinchTimer > 0.0f) {
                this.currentFrame = this.flinchTimer > 0.3f ? this.damageRight[0] : this.damageRight[1];
            } else if (this.isInAir) {
                this.currentFrame = this.velocity.y > 0.0f ? (Gdx.input.isKeyPressed(62) ? this.jumpShootRight[0] : this.jumpRight[0]) : (Gdx.input.isKeyPressed(62) ? this.jumpShootRight[1] : this.jumpRight[1]);
            } else if (this.isHadoukening) {
                float timeScaled = this.hadoukenTimer / 0.6f;
                int animationFrame = (double)timeScaled < 0.25 ? 2 : ((double)timeScaled < 0.5 ? 1 : 0);
                this.currentFrame = this.hadoukenRight[animationFrame];
            } else if (this.velocity.x == 0.0f) {
                this.currentFrame = Gdx.input.isKeyPressed(62) ? this.standShootRight : this.standRight;
            } else {
                this.animationTimer += deltaTime;
                int currentFrame = this.prevFrame;
                if (!this.isUnderwater && this.animationTimer > 0.175f || this.isUnderwater && this.animationTimer > 0.2625f) {
                    this.animationTimer = 0.0f;
                    if ((currentFrame = (currentFrame + 1) % 4) == 1 || currentFrame == 3) {
                        this.resources.footstepSound.play(0.5f);
                    }
                }
                this.currentFrame = Gdx.input.isKeyPressed(62) ? this.runShootRight[currentFrame] : this.runRight[currentFrame];
                this.prevFrame = currentFrame;
            }
        } else if (this.flinchTimer > 0.0f) {
            this.currentFrame = this.flinchTimer > 0.3f ? this.damageLeft[0] : this.damageLeft[1];
        } else if (this.isInAir) {
            this.currentFrame = this.velocity.y > 0.0f ? (Gdx.input.isKeyPressed(62) ? this.jumpShootLeft[0] : this.jumpLeft[0]) : (Gdx.input.isKeyPressed(62) ? this.jumpShootLeft[1] : this.jumpLeft[1]);
        } else if (this.isHadoukening) {
            float timeScaled = this.hadoukenTimer / 0.6f;
            int animationFrame = (double)timeScaled < 0.25 ? 2 : ((double)timeScaled < 0.5 ? 1 : 0);
            this.currentFrame = this.hadoukenLeft[animationFrame];
        } else if (this.velocity.x == 0.0f) {
            this.currentFrame = Gdx.input.isKeyPressed(62) ? this.standShootLeft : this.standLeft;
        } else {
            this.animationTimer += deltaTime;
            int currentFrame = this.prevFrame;
            if (!this.isUnderwater && this.animationTimer > 0.175f || this.isUnderwater && this.animationTimer > 0.2625f) {
                this.animationTimer = 0.0f;
                if ((currentFrame = (currentFrame + 1) % 4) == 1 || currentFrame == 3) {
                    this.resources.footstepSound.play(0.5f);
                }
            }
            this.currentFrame = Gdx.input.isKeyPressed(62) ? this.runShootLeft[currentFrame] : this.runLeft[currentFrame];
            this.prevFrame = currentFrame;
        }
    }

    private boolean checkCollisionsY() {
        this.hitBox.x = this.position.x;
        this.hitBox.y = this.position.y - 1.0f;
        this.hitBox.height = 33.0f;
        float obstacleTop = 0.0f;
        float hitBoxTop = this.hitBox.y + this.hitBox.height;
        boolean collided = false;
        for (GameEntity entity : this.obstacles) {
            Rectangle[] rectangleArray = entity.getHitArea();
            int n = rectangleArray.length;
            int n2 = 0;
            while (n2 < n) {
                Rectangle obstacle = rectangleArray[n2];
                if (obstacle.overlaps(this.hitBox)) {
                    obstacleTop = obstacle.y + obstacle.height;
                    if (hitBoxTop > obstacleTop && this.hitBox.y <= obstacleTop) {
                        if (this.isInAir) {
                            this.resources.landSound.stop();
                            this.resources.landSound.play(0.5f);
                        }
                        this.position.y = obstacle.y + obstacle.height;
                        this.hitBox.y = this.position.y - 1.0f;
                        hitBoxTop = this.hitBox.y + this.hitBox.height;
                        this.velocity.y = 0.0f;
                        this.isInAir = false;
                        collided = true;
                    } else if (hitBoxTop < obstacleTop && hitBoxTop > obstacle.y) {
                        this.position.y = obstacle.y - this.hitBox.height - 1.0f;
                        this.hitBox.y = this.position.y - 1.0f;
                        hitBoxTop = this.hitBox.y + this.hitBox.height;
                        this.velocity.y = 0.0f;
                        this.isJumping = false;
                        this.jumpThrustTimer = 0.0f;
                        this.isInAir = true;
                        collided = true;
                    }
                }
                ++n2;
            }
        }
        if (!collided) {
            this.isInAir = true;
        }
        this.hitBox.height = 32.0f;
        this.hitBox.y = this.position.y;
        return collided;
    }

    private boolean checkCollionsX() {
        this.hitBox.x = this.position.x;
        this.hitBox.y = this.position.y;
        float obstacleRightEdge = 0.0f;
        float hitBoxRightEdge = this.hitBox.x + 28.0f;
        boolean collided = false;
        for (GameEntity entity : this.obstacles) {
            Rectangle[] rectangleArray = entity.getHitArea();
            int n = rectangleArray.length;
            int n2 = 0;
            while (n2 < n) {
                Rectangle obstacle = rectangleArray[n2];
                if (obstacle.overlaps(this.hitBox)) {
                    obstacleRightEdge = obstacle.x + obstacle.width;
                    if (this.hitBox.x < obstacleRightEdge && hitBoxRightEdge > obstacleRightEdge) {
                        this.hitBox.x = this.position.x = obstacleRightEdge;
                        hitBoxRightEdge = this.hitBox.x + 28.0f;
                        if (this.velocity.x < 0.0f) {
                            this.velocity.x = 0.0f;
                        }
                        collided = true;
                    } else if (hitBoxRightEdge > obstacle.x && this.hitBox.x < obstacle.x) {
                        this.hitBox.x = this.position.x = obstacle.x - this.hitBox.width;
                        hitBoxRightEdge = this.hitBox.x + 28.0f;
                        if (this.velocity.x > 0.0f) {
                            this.velocity.x = 0.0f;
                        }
                        collided = true;
                    }
                }
                ++n2;
            }
        }
        return collided;
    }

    private void handleInput(float deltaTime) {
        if (Gdx.input.isKeyPressed(21) || Gdx.input.isKeyPressed(29)) {
            this.isFacingRight = false;
            this.velocity.x = Math.max(this.velocity.x - 1900.0f * deltaTime, -250.0f);
        }
        if (Gdx.input.isKeyPressed(22) || Gdx.input.isKeyPressed(32)) {
            this.isFacingRight = true;
            this.velocity.x = Math.min(this.velocity.x + 1900.0f * deltaTime, 250.0f);
        }
        if (Gdx.input.isKeyPressed(19) || Gdx.input.isKeyPressed(51)) {
            if (!this.isInAir && this.canJump) {
                this.isJumping = true;
                this.canJump = false;
                this.resources.jumpSound.play(0.5f);
            }
        } else {
            this.canJump = !this.isInAir;
            this.isJumping = false;
            this.jumpThrustTimer = 0.0f;
        }
        if (this.isJumping) {
            float jumpThrustTimeLimit = this.computeJumpThrustLimit();
            if (this.jumpThrustTimer < jumpThrustTimeLimit) {
                this.appliedVerticalDelta = Math.min(Math.abs(this.jumpThrustTimer - jumpThrustTimeLimit), deltaTime);
                this.velocity.y = 300.0f;
                this.jumpThrustTimer += deltaTime;
            } else {
                this.appliedVerticalDelta = 0.0f;
                this.isJumping = false;
                this.jumpThrustTimer = 0.0f;
            }
        } else {
            this.appliedVerticalDelta = deltaTime;
        }
        if (this.busterGun.canMakeShot(deltaTime) && Gdx.input.isKeyPressed(62) && !this.isHadoukening) {
            this.shotOrigin.set(this.position);
            this.shotOrigin.y += 16.0f;
            BusterShot.ShotDirection shotDir = BusterShot.ShotDirection.LEFT;
            if (this.isFacingRight) {
                this.shotOrigin.x += 16.0f;
                shotDir = BusterShot.ShotDirection.RIGHT;
            }
            this.tempShot = this.busterGun.makeShot(this.shotOrigin, shotDir, this.obstacles, this.targets);
            this.createdEntities.offer(this.tempShot);
        }
    }

    private void handlePhysics(float deltaTime) {
        if (this.velocity.x < 0.0f) {
            this.velocity.x = Math.min(this.velocity.x + 1300.0f * deltaTime, 0.0f);
        } else if (this.velocity.x > 0.0f) {
            this.velocity.x = Math.max(this.velocity.x - 1300.0f * deltaTime, 0.0f);
        }
        if (this.isInAir) {
            this.velocity.y = this.isUnderwater ? Math.max(this.velocity.y - 1600.0f * this.appliedVerticalDelta, -250.0f) : Math.max(this.velocity.y - 1600.0f * this.appliedVerticalDelta, -600.0f);
        }
    }

    @Override
    public void destroy() {
        this.health = 0;
    }

    @Override
    public int getWidth() {
        return 28;
    }

    @Override
    public int getHeight() {
        return 32;
    }

    public static class MegaPlayerResources {
        public Sound shootSound = null;
        public Sound shotMissSound = null;
        public Sound footstepSound = null;
        public Sound jumpSound = null;
        public Sound landSound = null;
        public Sound hurtSound = null;
        public Sound geminiSound = null;
        public Sound hadoukenSound = null;
        public Sound explodeSound = null;
        private boolean isLoaded = false;

        public void load() {
            if (!this.isLoaded) {
                this.footstepSound = Gdx.audio.newSound(Gdx.files.internal("sound/sfx-walk1.ogg"));
                this.hurtSound = Gdx.audio.newSound(Gdx.files.internal("sound/sfx-hurt1.ogg"));
                this.jumpSound = Gdx.audio.newSound(Gdx.files.internal("sound/sfx-jump1.ogg"));
                this.landSound = Gdx.audio.newSound(Gdx.files.internal("sound/sfx-land1.ogg"));
                this.shootSound = Gdx.audio.newSound(Gdx.files.internal("sound/sfx-buster-fire1.ogg"));
                this.geminiSound = Gdx.audio.newSound(Gdx.files.internal("sound/sfx-gemini-shot.ogg"));
                this.shotMissSound = Gdx.audio.newSound(Gdx.files.internal("sound/sfx-buster-miss1.ogg"));
                this.hadoukenSound = Gdx.audio.newSound(Gdx.files.internal("sound/sfx-hadouken.ogg"));
                this.explodeSound = Gdx.audio.newSound(Gdx.files.internal("sound/sfx-grenade-explode1.ogg"));
                this.isLoaded = true;
            }
        }

        public void unload() {
            if (this.isLoaded) {
                this.footstepSound.dispose();
                this.hurtSound.dispose();
                this.jumpSound.dispose();
                this.landSound.dispose();
                this.shootSound.dispose();
                this.geminiSound.dispose();
                this.hadoukenSound.dispose();
                this.shotMissSound.dispose();
                this.isLoaded = false;
            }
        }
    }
}

