/*
 * Decompiled with CFR 0.152.
 */
package com.me.mygdxgame.entities;

import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Vector3;
import com.me.mygdxgame.utilities.Renderer;
import com.me.mygdxgame.utilities.Updatable;

public class LightBorder
implements Updatable {
    private static final int BORDER_W = 10;
    private static final int BORDER_H = 10;
    private static final int FRAMES_X = 35;
    private static final int FRAME1_Y = 3;
    private static final int FRAME2_Y = 14;
    private static final int FRAME3_Y = 25;
    private static final int FRAME4_Y = 36;
    private static final int FRAME5_Y = 47;
    private static final float FRAMERATE = 0.25f;
    private Sprite[] borderFrames = new Sprite[8];
    private float animationTimer;
    private int frame;
    private int x;
    private int y;
    private int width;

    public LightBorder(Texture spriteSheet, int x, int y, int width) {
        this.borderFrames[0] = new Sprite(new TextureRegion(spriteSheet, 35, 3, 10, 10));
        this.borderFrames[1] = new Sprite(new TextureRegion(spriteSheet, 35, 14, 10, 10));
        this.borderFrames[2] = new Sprite(new TextureRegion(spriteSheet, 35, 25, 10, 10));
        this.borderFrames[3] = new Sprite(new TextureRegion(spriteSheet, 35, 36, 10, 10));
        this.borderFrames[4] = new Sprite(new TextureRegion(spriteSheet, 35, 47, 10, 10));
        this.borderFrames[5] = this.borderFrames[4];
        this.borderFrames[6] = this.borderFrames[3];
        this.borderFrames[7] = this.borderFrames[2];
        this.x = x;
        this.y = y;
        this.width = width;
        this.animationTimer = 0.0f;
    }

    @Override
    public void update(float deltaTime) {
        this.animationTimer += deltaTime;
        if (this.animationTimer > 0.25f) {
            this.animationTimer = 0.0f;
            this.frame = (this.frame + 1) % this.borderFrames.length;
        }
    }

    @Override
    public void draw(Renderer renderer) {
        Sprite currentSprite = this.borderFrames[this.frame];
        currentSprite.setBounds((float)this.x, (float)this.y, (float)this.width, 10.0f);
        renderer.drawSprite(currentSprite);
    }

    @Override
    public Vector3 getPosition() {
        return new Vector3((float)this.x, (float)this.y, 0.0f);
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return 10;
    }
}

