/*
 * Decompiled with CFR 0.152.
 */
package com.me.mygdxgame.entities;

import com.badlogic.gdx.audio.Sound;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector3;
import com.me.mygdxgame.utilities.EntityState;
import com.me.mygdxgame.utilities.GameEntity;
import com.me.mygdxgame.utilities.Renderer;
import java.util.NoSuchElementException;

public class Door
implements GameEntity {
    public static final int DOOR_SHUT_X = 0;
    public static final int DOOR_SHUT_Y = 440;
    public static final int DOOR_OPEN_X = 44;
    public static final int DOOR_OPEN_Y = 440;
    public static final int DOOR_W = 44;
    public static final int DOOR_H = 56;
    private TextureRegion doorShut;
    private TextureRegion doorOpen;
    private int x;
    private int y;
    private DoorState doorStatus;
    private Sound openSound;
    private Sound closeSound;
    private Rectangle hitbox = null;
    private Rectangle[] allHitAreas = null;

    public Door(Texture spriteSheet, Sound openSound, Sound closeSound, int x, int y) {
        this.x = x;
        this.y = y;
        this.hitbox = new Rectangle((float)x, (float)y, 44.0f, 56.0f);
        this.allHitAreas = new Rectangle[]{this.hitbox};
        this.openSound = openSound;
        this.closeSound = closeSound;
        this.doorShut = new TextureRegion(spriteSheet, 0, 440, 44, 56);
        this.doorOpen = new TextureRegion(spriteSheet, 44, 440, 44, 56);
        this.doorStatus = DoorState.SHUT;
    }

    @Override
    public void update(float deltaTime) {
    }

    @Override
    public void draw(Renderer renderer) {
        if (this.doorStatus == DoorState.SHUT) {
            renderer.drawRegion(this.doorShut, this.x, this.y);
        } else {
            renderer.drawRegion(this.doorOpen, this.x, this.y);
        }
    }

    @Override
    public EntityState getState() {
        return EntityState.Running;
    }

    @Override
    public boolean hasCreatedEntities() {
        return false;
    }

    @Override
    public GameEntity[] getCreatedEntities() throws NoSuchElementException {
        throw new NoSuchElementException();
    }

    public DoorState getDoorState() {
        return this.doorStatus;
    }

    public void setIsOpen(DoorState state, boolean playSound) {
        if (this.doorStatus != state) {
            this.doorStatus = state;
            if (playSound) {
                if (state == DoorState.OPEN) {
                    this.openSound.play();
                } else {
                    this.closeSound.play();
                }
            }
        }
    }

    public Rectangle getHitBox() {
        return this.hitbox;
    }

    @Override
    public Rectangle[] getHitArea() {
        return this.allHitAreas;
    }

    @Override
    public void destroy() {
    }

    @Override
    public Vector3 getPosition() {
        return new Vector3((float)this.x, (float)this.y, 0.0f);
    }

    @Override
    public int getWidth() {
        return 44;
    }

    @Override
    public int getHeight() {
        return 56;
    }

    public static enum DoorState {
        OPEN,
        SHUT;

    }
}

