/*
 * Decompiled with CFR 0.152.
 */
package com.me.mygdxgame.buster;

import com.badlogic.gdx.audio.Sound;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.math.Vector3;
import com.me.mygdxgame.entities.projectiles.BusterShot;
import com.me.mygdxgame.utilities.BusterPart;
import com.me.mygdxgame.utilities.Damageable;
import com.me.mygdxgame.utilities.GameEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class MegaBuster {
    protected static final int MAX_ATTACHMENTS = 2;
    protected List<BusterPart> attachments;
    protected boolean adapterPlugEnabled;
    protected Texture spritesheet;
    protected Sound missSound;
    protected Sound shootSound;
    protected static final int BASE_SHOT_ATTACK = 1;
    protected static final int BASE_SHOT_ENERGY = 3;
    protected static final int BASE_SHOT_RANGE = 300;
    protected static final int BASE_SHOT_RAPID = 300;
    protected static final int MAX_SHOT_RAPID = 600;
    protected static final int MAX_SHOT_ATTACK = 5;
    protected static final int MAX_SHOT_RANGE = 800;
    protected static final int MAX_SHOT_ENERGY = 9;
    protected static final float SFX_VOLUME = 0.5f;
    protected float energyTimer;

    public MegaBuster(Texture spriteSheet, Sound shootSound, Sound missSound) {
        this.spritesheet = spriteSheet;
        this.missSound = missSound;
        this.shootSound = shootSound;
        this.attachments = new ArrayList<BusterPart>();
    }

    public void setShootSound(Sound shootSound) {
        this.shootSound = shootSound;
    }

    public int attackStat() {
        int boost = this.calcAttackBoost();
        return Math.min(5, 1 + boost);
    }

    public int energyStat() {
        int boost = this.calcEnergyBoost();
        return Math.min(9, (int)(3.0 + 1.25 * (double)boost));
    }

    public int rangeStat() {
        int boost = this.calcRangeBoost();
        return Math.min(800, 300 + 100 * boost);
    }

    public int rapidStat() {
        int boost = this.calcRapidBoost();
        return Math.min(600, 300 + 60 * boost);
    }

    public int calcAttackBoost() {
        int sum = 0;
        for (BusterPart bp : this.attachments) {
            sum += bp.getAttack();
        }
        return sum;
    }

    public int calcEnergyBoost() {
        int sum = 0;
        for (BusterPart bp : this.attachments) {
            sum += bp.getEnergy();
        }
        return sum;
    }

    public int calcRangeBoost() {
        int sum = 0;
        for (BusterPart bp : this.attachments) {
            sum += bp.getRange();
        }
        return sum;
    }

    public int calcRapidBoost() {
        int sum = 0;
        for (BusterPart bp : this.attachments) {
            sum += bp.getRapid();
        }
        return sum;
    }

    public boolean hasBusterPart(BusterPart attachment) {
        return this.attachments.contains(attachment);
    }

    public boolean attachBusterPart(BusterPart attachment) {
        if (this.attachments.size() < this.attachmentLimit()) {
            this.attachments.add(attachment);
            return true;
        }
        return false;
    }

    public boolean removeBusterPart(BusterPart attachment) {
        if (this.hasBusterPart(attachment)) {
            this.attachments.remove(attachment);
            return true;
        }
        return false;
    }

    public boolean removeBusterPart(int index) {
        if (this.attachments.size() > index) {
            this.attachments.remove(index);
            return true;
        }
        return false;
    }

    public List<BusterPart> getAttachments() {
        return this.attachments;
    }

    public int attachmentLimit() {
        return 2 + (this.adapterPlugEnabled ? 1 : 0);
    }

    public boolean canMakeShot(float deltaTime) {
        if (this.energyTimer > 0.0f) {
            this.energyTimer = Math.max(0.0f, this.energyTimer - deltaTime);
            return false;
        }
        return true;
    }

    public BusterShot makeShot(Vector3 shotOrigin, BusterShot.ShotDirection dir, Collection<GameEntity> obstacles, Collection<Damageable> targets) {
        this.energyTimer = 1.0f / (float)this.energyStat();
        this.shootSound.play(0.5f);
        BusterShot shot = new BusterShot(this.spritesheet, this.missSound, shotOrigin, this.rapidStat(), dir, this.attackStat(), this.rangeStat(), obstacles, targets);
        shot.setShotColor(this.calcShotColor());
        shot.setShotScale(this.calcShotScale());
        return shot;
    }

    protected Color calcShotColor() {
        Color result;
        switch (this.calcAttackBoost()) {
            case 1: {
                result = new Color(8.0f, 0.6f, 0.8f, 1.0f);
                break;
            }
            case 2: {
                result = new Color(0.8f, 0.8f, 1.0f, 1.0f);
                break;
            }
            case 3: {
                result = new Color(0.6f, 1.0f, 0.6f, 1.0f);
                break;
            }
            case 4: {
                result = new Color(1.0f, 0.8f, 0.8f, 1.0f);
                break;
            }
            case 5: {
                result = new Color(1.0f, 1.0f, 0.3f, 1.0f);
                break;
            }
            default: {
                result = Color.WHITE;
            }
        }
        return result;
    }

    protected float calcShotScale() {
        return Math.min(1.5f, 1.0f + 0.5f * (float)(this.calcAttackBoost() / 5));
    }
}

