/*
 * Decompiled with CFR 0.152.
 */
package com.me.mygdxgame;

import com.badlogic.gdx.ApplicationListener;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.PerspectiveCamera;
import com.me.mygdxgame.screens.seeteufelscreen.SeeteufelScreen;
import com.me.mygdxgame.utilities.GameScreen;
import com.me.mygdxgame.utilities.GameState;
import java.util.ArrayList;

public class MyGdxGame
implements ApplicationListener {
    public static final int SCREEN_WIDTH = 700;
    public static final int SCREEN_HEIGHT = 376;
    public static final int MAX_LIVES = 3;
    private OrthographicCamera orthoCamera;
    private PerspectiveCamera perspectiveCamera;
    private GameScreen currentGameScreen = null;
    private ArrayList<GameScreen> games = new ArrayList();
    private ArrayList<GameScreen> miniBossGames = new ArrayList();
    private ArrayList<GameScreen> bossGames = new ArrayList();
    private int lives = 3;
    private int difficulty = 0;

    public void create() {
        try {
            Gdx.app.setLogLevel(0);
            this.games.add(new SeeteufelScreen());
            for (GameScreen game : this.games) {
                game.load();
                game.initialize();
            }
            this.currentGameScreen = this.games.get((int)(Math.random() * (double)this.games.size()));
            this.orthoCamera = new OrthographicCamera((float)Gdx.graphics.getWidth(), (float)Gdx.graphics.getHeight());
            this.orthoCamera.update();
            this.perspectiveCamera = new PerspectiveCamera(60.0f, (float)Gdx.graphics.getWidth(), (float)Gdx.graphics.getHeight());
            this.perspectiveCamera.far = 5000.0f;
            this.perspectiveCamera.position.z = 256.0f;
            this.perspectiveCamera.update();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void resize(int width, int height) {
        Gdx.graphics.setDisplayMode(700, 376, Gdx.graphics.isFullscreen());
        this.orthoCamera.viewportWidth = Gdx.graphics.getWidth();
        this.orthoCamera.viewportHeight = Gdx.graphics.getHeight();
        this.orthoCamera.update();
        this.perspectiveCamera.viewportWidth = Gdx.graphics.getWidth();
        this.perspectiveCamera.viewportHeight = Gdx.graphics.getHeight();
        this.perspectiveCamera.update();
    }

    public void render() {
        if (this.currentGameScreen.getState() == GameState.Running) {
            this.currentGameScreen.render(Gdx.graphics.getDeltaTime(), this.difficulty, this.perspectiveCamera, this.orthoCamera);
        } else {
            this.currentGameScreen.initialize();
        }
    }

    public void pause() {
    }

    public void resume() {
    }

    public void dispose() {
        for (GameScreen game : this.games) {
            game.unload();
        }
        for (GameScreen game : this.miniBossGames) {
            game.unload();
        }
        for (GameScreen game : this.bossGames) {
            game.unload();
        }
    }
}

