/*
 * Decompiled with CFR 0.152.
 */
package com.me.mygdxgame.utilities;

import com.badlogic.gdx.InputProcessor;
import com.me.mygdxgame.utilities.SpecialCombo;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SpecialComboListener
implements InputProcessor {
    private static final float MAX_COMBO_TIME = 0.2f;
    private float comboTimer = 0.0f;
    private List<Integer> comboSequence = new ArrayList<Integer>();
    private List<SpecialCombo> combos = new ArrayList<SpecialCombo>();

    public void updateComboTimer(float deltaTime) {
        this.comboTimer += deltaTime;
        if (this.comboTimer >= 0.2f) {
            this.resetComboTimer();
            this.comboSequence.clear();
        }
    }

    private void resetComboTimer() {
        this.comboTimer = 0.0f;
    }

    private static String sequenceStr(List<Integer> seq) {
        StringBuilder builder = new StringBuilder();
        Iterator<Integer> iter = seq.iterator();
        while (iter.hasNext()) {
            builder.append(iter.next());
        }
        return builder.toString();
    }

    public SpecialCombo getMatchedCombo() {
        for (SpecialCombo sc : this.combos) {
            String testCombo = SpecialComboListener.sequenceStr(sc.getSequence());
            String thisCombo = SpecialComboListener.sequenceStr(this.comboSequence);
            if (thisCombo.lastIndexOf(testCombo) != thisCombo.length() - testCombo.length()) continue;
            this.comboSequence.clear();
            return sc;
        }
        return null;
    }

    public boolean addCombo(SpecialCombo sc) {
        if (!this.combos.contains(sc)) {
            this.combos.add(sc);
            return true;
        }
        return false;
    }

    public boolean removeCombo(SpecialCombo sc) {
        if (this.combos.contains(sc)) {
            this.combos.remove(sc);
            return true;
        }
        return false;
    }

    public boolean keyUp(int keycode) {
        return false;
    }

    public boolean keyDown(int keycode) {
        this.comboSequence.add(keycode);
        this.resetComboTimer();
        return false;
    }

    public boolean keyTyped(char character) {
        return false;
    }

    public boolean touchDown(int screenX, int screenY, int pointer, int button) {
        return false;
    }

    public boolean touchUp(int screenX, int screenY, int pointer, int button) {
        return false;
    }

    public boolean touchDragged(int screenX, int screenY, int pointer) {
        return false;
    }

    public boolean mouseMoved(int screenX, int screenY) {
        return false;
    }

    public boolean scrolled(int amount) {
        return false;
    }
}

