/*
 * Decompiled with CFR 0.152.
 */
package com.me.mygdxgame.utilities;

import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.audio.Sound;
import com.me.mygdxgame.utilities.GameCheat;
import java.util.ArrayList;
import java.util.List;

public class GameCheatListener
implements InputProcessor {
    private static final float SFX_VOLUME = 0.5f;
    protected List<GameCheat> cheats = new ArrayList<GameCheat>();
    protected List<Integer> keySequence = new ArrayList<Integer>();
    protected int maxSequenceSize;
    private Sound successSound;

    public GameCheatListener(int maxSequenceSize, Sound successSound) {
        this.maxSequenceSize = maxSequenceSize;
        this.successSound = successSound;
    }

    public boolean keyUp(int keycode) {
        if (this.keySequence.size() == this.maxSequenceSize) {
            this.keySequence.remove(0);
        }
        this.keySequence.add(keycode);
        this.checkCheats();
        return false;
    }

    public boolean addCheat(GameCheat cheat) {
        if (!this.cheats.contains(cheat)) {
            this.cheats.add(cheat);
            return true;
        }
        return false;
    }

    private void checkCheats() {
        boolean success = false;
        for (GameCheat gc : this.cheats) {
            if (!this.keyLogContainsSequence(gc.getSequence())) continue;
            if (!gc.isEnabled()) {
                gc.enableCheat();
            } else {
                gc.disableCheat();
            }
            success = true;
            this.keySequence.clear();
        }
        if (success) {
            this.successSound.play(0.5f);
        }
    }

    private boolean keyLogContainsSequence(List<Integer> seq) {
        return this.sequenceAsText(this.keySequence).indexOf(this.sequenceAsText(seq)) != -1;
    }

    private String sequenceAsText(List<Integer> seq) {
        StringBuilder builder = new StringBuilder();
        for (Integer key : seq) {
            builder.append(this.sanitizeWASD(key));
        }
        return builder.toString();
    }

    public int sanitizeWASD(int keyCode) {
        if (keyCode == 19 || keyCode == 51) {
            return -2;
        }
        if (keyCode == 20 || keyCode == 47) {
            return -3;
        }
        if (keyCode == 21 || keyCode == 29) {
            return -4;
        }
        if (keyCode == 22 || keyCode == 32) {
            return -5;
        }
        return keyCode;
    }

    public List<GameCheat> getAllCheats() {
        return this.cheats;
    }

    public List<GameCheat> getEnabledCheats() {
        ArrayList<GameCheat> result = new ArrayList<GameCheat>();
        for (GameCheat gc : this.cheats) {
            if (!gc.isEnabled()) continue;
            result.add(gc);
        }
        return result;
    }

    public List<GameCheat> getDisabledCheats() {
        ArrayList<GameCheat> result = new ArrayList<GameCheat>();
        for (GameCheat gc : this.cheats) {
            if (gc.isEnabled()) continue;
            result.add(gc);
        }
        return result;
    }

    public boolean containsCheat(GameCheat gc) {
        return this.getAllCheats().contains(gc);
    }

    public boolean hasEnabledCheat(GameCheat gc) {
        return this.getEnabledCheats().contains(gc);
    }

    public boolean containsCheats(GameCheat ... gcs) {
        GameCheat[] gameCheatArray = gcs;
        int n = gcs.length;
        int n2 = 0;
        while (n2 < n) {
            GameCheat gc = gameCheatArray[n2];
            if (!this.containsCheat(gc)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public boolean hasEnabledCheats(GameCheat ... gcs) {
        GameCheat[] gameCheatArray = gcs;
        int n = gcs.length;
        int n2 = 0;
        while (n2 < n) {
            GameCheat gc = gameCheatArray[n2];
            if (!this.hasEnabledCheat(gc)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public void disableAllCheats() {
        for (GameCheat gc : this.cheats) {
            gc.disableCheat();
        }
    }

    public boolean keyDown(int keycode) {
        return false;
    }

    public boolean keyTyped(char character) {
        return false;
    }

    public boolean touchDown(int screenX, int screenY, int pointer, int button) {
        return false;
    }

    public boolean touchUp(int screenX, int screenY, int pointer, int button) {
        return false;
    }

    public boolean touchDragged(int screenX, int screenY, int pointer) {
        return false;
    }

    public boolean mouseMoved(int screenX, int screenY) {
        return false;
    }

    public boolean scrolled(int amount) {
        return false;
    }
}

