/*
 * Decompiled with CFR 0.152.
 */
package com.me.mygdxgame.screens.seeteufelscreen.maps;

import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector3;
import com.me.mygdxgame.entities.StonePillar;
import com.me.mygdxgame.screens.seeteufelscreen.SeeteufelScreen;
import com.me.mygdxgame.utilities.GameEntity;
import com.me.mygdxgame.utilities.GameMap;
import com.me.mygdxgame.utilities.GenericEntity;
import com.me.mygdxgame.utilities.Renderer;
import java.util.Arrays;

public class FirstMap
extends GameMap {
    private int animationFrame = 0;
    private float animationTimer = 0.0f;
    private Sprite rockSprite;
    private Sprite wallSprite;
    private Sprite smallMazeSprite;
    private TextureRegion greyBlockRegion;
    private TextureRegion pedistalRegion;
    private Sprite pillarSprite;
    private TextureRegion grateRegion;
    private TextureRegion[] waterfall;
    private StonePillar[] stonePillars;
    private Rectangle[] obstacles = null;
    private GenericEntity returnObstacles = null;
    public static final int GROUND_DIM = 32;
    public static final int GROUND_ORIGIN_X = -350;
    public static final int GROUND_ORIGIN_Y = -188;
    public static final int GROUND_HEIGHT = 1;
    public static final int GROUND_WIDTH = 26;
    public static final int ROOM_HEIGHT = 7;
    public static final int GROUND_END_X = 482;
    public static final int GROUND_START_Y = -156;
    public static final int PLATFORM_START_X = -126;
    public static final Vector3 INIT_POS = new Vector3(450.0f, -156.0f, 0.0f);

    public FirstMap(Texture spriteSheet, SeeteufelScreen.MapTiles tiles) {
        this.rockSprite = new Sprite(tiles.rockTex);
        this.rockSprite.setBounds(-350.0f, 68.0f, 832.0f, 32.0f);
        this.rockSprite.setU2(26.0f);
        this.wallSprite = new Sprite(tiles.wallTex);
        this.smallMazeSprite = new Sprite(tiles.smallMazeTex);
        this.smallMazeSprite.setBounds(-350.0f, -156.0f, 832.0f, 224.0f);
        this.smallMazeSprite.setU2(26.0f);
        this.smallMazeSprite.setV2(7.0f);
        this.pillarSprite = new Sprite(tiles.pillarTex);
        this.pillarSprite.setSize(32.0f, 216.0f);
        this.pillarSprite.setV2(7.0f);
        this.greyBlockRegion = new TextureRegion(tiles.greyBlockTex, 0, 0, 32, 32);
        this.pedistalRegion = new TextureRegion(spriteSheet, 165, 0, 55, 17);
        this.grateRegion = new TextureRegion(spriteSheet, 22, 102, 23, 23);
        this.waterfall = new TextureRegion[5];
        this.waterfall[0] = new TextureRegion(spriteSheet, 0, 125, 31, 84);
        this.waterfall[1] = new TextureRegion(spriteSheet, 32, 125, 31, 84);
        this.waterfall[2] = new TextureRegion(spriteSheet, 64, 125, 31, 84);
        this.waterfall[3] = new TextureRegion(spriteSheet, 96, 125, 31, 84);
        this.waterfall[4] = new TextureRegion(spriteSheet, 128, 125, 31, 84);
        this.obstacles = new Rectangle[]{new Rectangle(-350.0f, -188.0f, 832.0f, 32.0f), new Rectangle(-158.0f, -156.0f, 160.0f, 32.0f), new Rectangle(-126.0f, -124.0f, 96.0f, 32.0f), new Rectangle(-106.0f, -92.0f, (float)this.pedistalRegion.getRegionWidth(), (float)this.pedistalRegion.getRegionHeight()), new Rectangle(-350.0f, 68.0f, 832.0f, 32.0f), new Rectangle(-382.0f, -188.0f, 32.0f, 224.0f), new Rectangle(482.0f, -188.0f, 32.0f, 224.0f)};
        this.returnObstacles = new GenericEntity(Arrays.asList(this.obstacles));
        this.stonePillars = new StonePillar[10];
        int i = 0;
        while (i < 2) {
            this.stonePillars[i] = new StonePillar(spriteSheet, tiles, -350 + (2 * i + 1) * 16 - 9, -156, 224);
            ++i;
        }
        i = 0;
        while (i < 8) {
            this.stonePillars[i + 2] = new StonePillar(spriteSheet, tiles, 137 + 32 * i, -156, 224);
            ++i;
        }
    }

    @Override
    public Vector3 getInitialPosition() {
        return INIT_POS;
    }

    @Override
    public GameEntity getObstacles() {
        return this.returnObstacles;
    }

    @Override
    public void render(float deltaTime, Rectangle visibleRegion, Renderer renderer) {
        StonePillar pillar;
        renderer.drawSprite(this.smallMazeSprite);
        FirstMap.diagonalRight(renderer, this.greyBlockRegion, -222, -156, 5);
        FirstMap.diagonalLeft(renderer, this.greyBlockRegion, 34, -156, 4);
        renderer.drawSprite(this.rockSprite);
        this.wallSprite.setBounds(-350.0f, -188.0f, 832.0f, 32.0f);
        this.wallSprite.setU2(26.0f);
        renderer.drawSprite(this.wallSprite);
        this.wallSprite.setBounds(-158.0f, -156.0f, 160.0f, 32.0f);
        this.wallSprite.setU2(5.0f);
        renderer.drawSprite(this.wallSprite);
        this.wallSprite.setBounds(-126.0f, -124.0f, 96.0f, 32.0f);
        this.wallSprite.setU2(3.0f);
        renderer.drawSprite(this.wallSprite);
        renderer.drawRegion(this.greyBlockRegion, -94.0f, -92.0f);
        renderer.drawRegion(this.pedistalRegion, -106.0f, -92.0f);
        renderer.drawRegion(this.grateRegion, -258.0f, -92.0f);
        renderer.drawRegion(this.grateRegion, 78.0f, -92.0f);
        renderer.drawRegion(this.waterfall[this.animationFrame], -262.0f, -156.0f);
        renderer.drawRegion(this.waterfall[this.animationFrame], 74.0f, -156.0f);
        StonePillar[] stonePillarArray = this.stonePillars;
        int n = this.stonePillars.length;
        int n2 = 0;
        while (n2 < n) {
            pillar = stonePillarArray[n2];
            pillar.renderBody(renderer);
            ++n2;
        }
        stonePillarArray = this.stonePillars;
        n = this.stonePillars.length;
        n2 = 0;
        while (n2 < n) {
            pillar = stonePillarArray[n2];
            pillar.renderBases(renderer);
            ++n2;
        }
        if (this.debugMode) {
            FirstMap.drawObstacles(renderer, this.getObstacles().getHitArea(), GameMap.DEFAULT_OBSTACLE_COLOR);
        }
    }

    @Override
    public void update(float deltaTime) {
        this.animationTimer += deltaTime;
        if ((double)this.animationTimer >= 0.1) {
            this.animationFrame = (this.animationFrame + 1) % 5;
            this.animationTimer = 0.0f;
        }
    }
}

