/*
 * Decompiled with CFR 0.152.
 */
package com.me.mygdxgame.screens.maptestscreen;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.PerspectiveCamera;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector3;
import com.me.mygdxgame.utilities.GameMap;
import com.me.mygdxgame.utilities.GameScreen;
import com.me.mygdxgame.utilities.GameState;
import com.me.mygdxgame.utilities.Renderer;

public class MapTestScreen
implements GameScreen {
    private static final Vector3 CAM_INITIAL_POSITION = new Vector3(0.0f, 0.0f, 256.0f);
    private GameMap map = null;
    private Vector3 camPos = new Vector3(CAM_INITIAL_POSITION);
    private Rectangle visibleArea = new Rectangle(-1000.0f, -1000.0f, 2000.0f, 2000.0f);

    public MapTestScreen(GameMap map) {
        this.map = map;
    }

    @Override
    public void load() {
    }

    @Override
    public void unload() {
    }

    @Override
    public void render(float deltaTime, int difficulty, PerspectiveCamera perspCam, OrthographicCamera orthoCam) {
        if (Gdx.input.isKeyPressed(29)) {
            this.camPos.x -= 180.0f * deltaTime;
        }
        if (Gdx.input.isKeyPressed(32)) {
            this.camPos.x += 180.0f * deltaTime;
        }
        if (Gdx.input.isKeyPressed(47)) {
            this.camPos.y -= 180.0f * deltaTime;
        }
        if (Gdx.input.isKeyPressed(51)) {
            this.camPos.y += 180.0f * deltaTime;
        }
        if (Gdx.input.isKeyPressed(33)) {
            this.camPos.z -= 180.0f * deltaTime;
        }
        if (Gdx.input.isKeyPressed(45)) {
            this.camPos.z += 180.0f * deltaTime;
        }
        perspCam.position.set(this.camPos);
        perspCam.update();
        Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        Gdx.gl.glClear(16640);
        Renderer renderer = new Renderer(perspCam.combined);
        this.map.render(deltaTime, this.visibleArea, renderer);
    }

    @Override
    public void initialize() {
        this.camPos.set(CAM_INITIAL_POSITION);
    }

    @Override
    public GameState getState() {
        return GameState.Running;
    }
}

