/*
 * Decompiled with CFR 0.152.
 */
package com.me.mygdxgame.entities.projectiles;

import com.badlogic.gdx.audio.Sound;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector3;
import com.me.mygdxgame.entities.particles.Explosion;
import com.me.mygdxgame.utilities.Damageable;
import com.me.mygdxgame.utilities.Damager;
import com.me.mygdxgame.utilities.EntityState;
import com.me.mygdxgame.utilities.GameEntity;
import com.me.mygdxgame.utilities.Renderer;
import java.util.NoSuchElementException;

public class Rocket
implements GameEntity,
Damager {
    private static final int ROCKET_X = 210;
    private static final int ROCKET_Y = 175;
    private static final int ROCKET_W = 16;
    private static final int ROCKET_H = 16;
    private static final Color ROCKET_TINT = new Color(1.0f, 0.75f, 0.75f, 1.0f);
    private static final float SFX_VOLUME = 0.5f;
    private TextureRegion rocket;
    private float animationTimer = 0.0f;
    private Texture spriteSheet = null;
    private Vector3 position = new Vector3(0.0f, 0.0f, 0.0f);
    private Vector3 velocity = new Vector3(0.0f, 0.0f, 0.0f);
    private GameEntity[] obstacles;
    private Damageable[] targets;
    private EntityState state;
    private float prevZ;
    private Rectangle hitBox = null;
    private Rectangle[] allHitAreas = null;
    private int power = 0;
    private int knockback = 0;
    private Sound explosion = null;
    private Explosion[] explosions;

    public Rocket(Texture spriteSheet, Sound explosion, Vector3 position, Vector3 velocity, int power, int knockback, GameEntity[] obstacles, Damageable[] targets) {
        this.spriteSheet = spriteSheet;
        this.explosion = explosion;
        this.position.set(position);
        this.position.x -= 8.0f;
        this.position.y -= 8.0f;
        this.velocity = velocity;
        this.rocket = new TextureRegion(this.spriteSheet, 210, 175, 16, 16);
        this.obstacles = obstacles;
        this.targets = targets;
        this.state = EntityState.Running;
        this.power = power;
        this.knockback = knockback;
        this.hitBox = new Rectangle(position.x, position.y, 16.0f, 16.0f);
        this.allHitAreas = new Rectangle[]{this.hitBox};
    }

    @Override
    public void update(float deltaTime) {
        this.prevZ = this.position.z;
        if (this.state == EntityState.Running) {
            int n;
            this.position.x += this.velocity.x * deltaTime;
            this.position.y += this.velocity.y * deltaTime;
            this.position.z += this.velocity.z * deltaTime;
            this.hitBox.setPosition(this.position.x, this.position.y);
            GameEntity[] gameEntityArray = this.obstacles;
            int n2 = this.obstacles.length;
            int n3 = 0;
            while (n3 < n2) {
                GameEntity entity = gameEntityArray[n3];
                Rectangle[] rectangleArray = entity.getHitArea();
                n = rectangleArray.length;
                int n4 = 0;
                while (n4 < n) {
                    Rectangle r = rectangleArray[n4];
                    if (r.overlaps(this.hitBox) && (this.prevZ < 0.0f && this.position.z > 0.0f || this.prevZ > 0.0f && this.position.z < 0.0f || this.position.z == 0.0f)) {
                        this.explode();
                        return;
                    }
                    ++n4;
                }
                ++n3;
            }
            Rectangle[] hitAreas = null;
            Damageable[] damageableArray = this.targets;
            int n5 = this.targets.length;
            n2 = 0;
            while (n2 < n5) {
                Damageable d = damageableArray[n2];
                Rectangle[] rectangleArray = hitAreas = d.getHitArea();
                int n6 = hitAreas.length;
                n = 0;
                while (n < n6) {
                    Rectangle r = rectangleArray[n];
                    if (r.overlaps(this.hitBox) && (this.prevZ < 0.0f && this.position.z > 0.0f || this.prevZ > 0.0f && this.position.z < 0.0f || this.position.z == 0.0f)) {
                        d.damage(this);
                        this.explode();
                        return;
                    }
                    ++n;
                }
                ++n2;
            }
            this.animationTimer += deltaTime;
        }
    }

    @Override
    public void draw(Renderer renderer) {
        if (this.state == EntityState.Running) {
            renderer.drawRegion(this.rocket, this.position.x, this.position.y, ROCKET_TINT, 1.0f, 1.0f, (int)(300.0f * this.animationTimer));
        }
    }

    @Override
    public EntityState getState() {
        return this.state;
    }

    @Override
    public boolean hasCreatedEntities() {
        return this.explosions != null;
    }

    @Override
    public GameEntity[] getCreatedEntities() throws NoSuchElementException {
        if (this.explosions == null) {
            throw new NoSuchElementException();
        }
        GameEntity[] returnList = this.explosions;
        this.explosions = null;
        return returnList;
    }

    private void explode() {
        this.position.x += 8.0f;
        this.position.y += 8.0f;
        this.explosions = new Explosion[4];
        this.explosions[0] = new Explosion(this.spriteSheet, new Vector3(this.position.x + 12.0f, this.position.y + 12.0f, this.position.z));
        this.explosions[1] = new Explosion(this.spriteSheet, new Vector3(this.position.x - 12.0f, this.position.y + 12.0f, this.position.z));
        this.explosions[2] = new Explosion(this.spriteSheet, new Vector3(this.position.x + 12.0f, this.position.y - 12.0f, this.position.z));
        this.explosions[3] = new Explosion(this.spriteSheet, new Vector3(this.position.x - 12.0f, this.position.y - 12.0f, this.position.z));
        this.explosion.stop();
        this.explosion.play(0.5f);
        this.state = EntityState.Destroyed;
    }

    @Override
    public Rectangle[] getHitArea() {
        return this.allHitAreas;
    }

    @Override
    public void destroy() {
        this.state = EntityState.Destroyed;
    }

    @Override
    public Vector3 getPosition() {
        return new Vector3(this.position);
    }

    @Override
    public int getWidth() {
        return 16;
    }

    @Override
    public int getHeight() {
        return 16;
    }

    @Override
    public int getPower() {
        return this.power;
    }

    @Override
    public int getKnockback() {
        return this.knockback;
    }
}

