/*
 * Decompiled with CFR 0.152.
 */
package com.me.mygdxgame.entities.projectiles;

import com.badlogic.gdx.audio.Sound;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector3;
import com.me.mygdxgame.entities.particles.Explosion;
import com.me.mygdxgame.utilities.Damageable;
import com.me.mygdxgame.utilities.Damager;
import com.me.mygdxgame.utilities.EntityState;
import com.me.mygdxgame.utilities.GameEntity;
import com.me.mygdxgame.utilities.Renderer;
import java.util.NoSuchElementException;

public class Bomb
implements GameEntity,
Damager {
    private static final int BOMB_X = 210;
    private static final int BOMB_Y = 175;
    private static final int BOMB_W = 16;
    private static final int BOMB_H = 16;
    private static final float GRAVITY = 250.0f;
    private static final int EXPLOSION_EXPANSION = 30;
    private static final float MIN_GRAV = -180.0f;
    private static final float SFX_VOLUME = 0.5f;
    private TextureRegion bomb;
    private float animationTimer = 0.0f;
    private Texture spriteSheet = null;
    private Vector3 position = new Vector3(0.0f, 0.0f, 0.0f);
    private Vector3 velocity = new Vector3(0.0f, 0.0f, 0.0f);
    private GameEntity[] obstacles;
    private Damageable[] targets;
    private EntityState status;
    private float prevZ;
    private Rectangle hitBox = new Rectangle(0.0f, 0.0f, 16.0f, 16.0f);
    private int power = 0;
    private int knockback = 0;
    private Sound explosion = null;
    private Explosion[] explosions;
    private Rectangle[] hitAreas = new Rectangle[1];

    public Bomb(Texture spriteSheet, Sound explosion, Vector3 position, Vector3 velocity, int power, int knockback, GameEntity[] obstacles, Damageable[] targets) {
        this.spriteSheet = spriteSheet;
        this.explosion = explosion;
        this.position.set(position);
        this.position.x -= 8.0f;
        this.position.y -= 8.0f;
        this.velocity.set(velocity);
        this.bomb = new TextureRegion(this.spriteSheet, 210, 175, 16, 16);
        this.obstacles = obstacles;
        this.power = power;
        this.knockback = knockback;
        this.targets = targets;
        this.status = EntityState.Running;
        this.hitAreas[0] = this.hitBox;
    }

    @Override
    public void update(float deltaTime) {
        this.prevZ = this.position.z;
        if (this.status == EntityState.Running) {
            Rectangle r;
            int n;
            int n2;
            Rectangle[] rectangleArray;
            this.position.x += this.velocity.x * deltaTime;
            this.position.y += this.velocity.y * deltaTime;
            this.velocity.y = Math.max(-180.0f, this.velocity.y - 250.0f * deltaTime);
            this.position.z += this.velocity.z * deltaTime;
            this.hitBox.setPosition(this.position.x, this.position.y);
            GameEntity[] gameEntityArray = this.obstacles;
            int n3 = this.obstacles.length;
            int n4 = 0;
            while (n4 < n3) {
                GameEntity entity = gameEntityArray[n4];
                rectangleArray = entity.getHitArea();
                n2 = rectangleArray.length;
                n = 0;
                while (n < n2) {
                    r = rectangleArray[n];
                    if (r.overlaps(this.hitBox) && (this.prevZ < 0.0f && this.position.z > 0.0f || this.prevZ > 0.0f && this.position.z < 0.0f || this.position.z == 0.0f)) {
                        this.explode();
                        int hitboxOffset = 15;
                        this.hitBox.x -= (float)hitboxOffset;
                        this.hitBox.y -= (float)hitboxOffset;
                        this.hitBox.width += 30.0f;
                        this.hitBox.height += 30.0f;
                        this.explode();
                        break;
                    }
                    ++n;
                }
                if (this.status == EntityState.Destroyed) break;
                ++n4;
            }
            gameEntityArray = this.targets;
            n3 = this.targets.length;
            n4 = 0;
            while (n4 < n3) {
                GameEntity d = gameEntityArray[n4];
                rectangleArray = d.getHitArea();
                n2 = rectangleArray.length;
                n = 0;
                while (n < n2) {
                    r = rectangleArray[n];
                    if (r.overlaps(this.hitBox) && (this.prevZ < 0.0f && this.position.z > 0.0f || this.prevZ > 0.0f && this.position.z < 0.0f || this.position.z == 0.0f)) {
                        d.damage(this);
                        this.explode();
                    }
                    ++n;
                }
                ++n4;
            }
            this.animationTimer += deltaTime;
        }
    }

    @Override
    public void draw(Renderer renderer) {
        if (this.status == EntityState.Running) {
            renderer.drawRegion(this.bomb, this.position.x, this.position.y, Color.WHITE, 1.0f, 1.0f, (int)(300.0f * this.animationTimer));
        }
    }

    @Override
    public EntityState getState() {
        return this.status;
    }

    @Override
    public boolean hasCreatedEntities() {
        return this.explosions != null;
    }

    @Override
    public GameEntity[] getCreatedEntities() throws NoSuchElementException {
        if (this.explosions == null) {
            throw new NoSuchElementException();
        }
        GameEntity[] returnList = this.explosions;
        this.explosions = null;
        return returnList;
    }

    private void explode() {
        if (this.status != EntityState.Destroyed) {
            this.position.x += 8.0f;
            this.position.y += 8.0f;
            this.explosions = new Explosion[4];
            this.explosions[0] = new Explosion(this.spriteSheet, new Vector3(this.position.x + 12.0f, this.position.y + 12.0f, this.position.z));
            this.explosions[1] = new Explosion(this.spriteSheet, new Vector3(this.position.x - 12.0f, this.position.y + 12.0f, this.position.z));
            this.explosions[2] = new Explosion(this.spriteSheet, new Vector3(this.position.x + 12.0f, this.position.y - 12.0f, this.position.z));
            this.explosions[3] = new Explosion(this.spriteSheet, new Vector3(this.position.x - 12.0f, this.position.y - 12.0f, this.position.z));
            this.explosion.stop();
            this.explosion.play(0.5f);
            this.status = EntityState.Destroyed;
        }
    }

    @Override
    public Rectangle[] getHitArea() {
        return this.hitAreas;
    }

    @Override
    public void destroy() {
        this.status = EntityState.Destroyed;
    }

    @Override
    public Vector3 getPosition() {
        return new Vector3(this.position);
    }

    @Override
    public int getWidth() {
        return 16;
    }

    @Override
    public int getHeight() {
        return 16;
    }

    @Override
    public int getPower() {
        return this.power;
    }

    @Override
    public int getKnockback() {
        return this.knockback;
    }
}

