/*
 * Decompiled with CFR 0.152.
 */
package com.me.mygdxgame.entities.progressbars;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.Vector3;
import com.me.mygdxgame.utilities.ProgressBar;
import com.me.mygdxgame.utilities.Renderer;

public class MegaHealthBar
implements ProgressBar {
    private static final int CHROME_X = 38;
    private static final int CHROME_Y = 497;
    private static final int CHROME_H = 68;
    private static final int CHROME_W = 14;
    private static final int BAR_X = 4;
    private static final int BAR_Y = 20;
    private static final int BAR_W = 7;
    private static final int BAR_H = 39;
    private static final int DANGER_X = 9;
    private static final int DANGER_Y = 529;
    private static final int SAFETY_X = 0;
    private static final int SAFETY_Y = 529;
    private static final int SIGNAL_W = 9;
    private static final int SIGNAL_H = 9;
    private static final int SIGNAL_X = 3;
    private static final int SIGNAL_Y = 2;
    private static final Color BAR_COLOR = Color.YELLOW;
    private static final Color BAR_BACK_COLOR = Color.BLACK;
    protected float value = 1.0f;
    private int barSize;
    private int x;
    private int y;
    private TextureRegion chrome;
    private TextureRegion dangerSignal;
    private TextureRegion safetySignal;
    private boolean inDanger;

    public MegaHealthBar(Texture spriteSheet, int x, int y) {
        this.chrome = new TextureRegion(spriteSheet, 38, 497, 14, 68);
        this.dangerSignal = new TextureRegion(spriteSheet, 9, 529, 9, 9);
        this.safetySignal = new TextureRegion(spriteSheet, 0, 529, 9, 9);
        this.x = x;
        this.y = y;
        this.inDanger = true;
    }

    public void setInDanger(boolean inDanger) {
        this.inDanger = inDanger;
    }

    @Override
    public void update(float deltaTime) {
    }

    @Override
    public void draw(Renderer renderer) {
        renderer.drawRect(ShapeRenderer.ShapeType.Filled, BAR_BACK_COLOR, this.x + 4, this.y + 20, 7.0f, 39.0f);
        renderer.drawRect(ShapeRenderer.ShapeType.Filled, BAR_COLOR, this.x + 4, this.y + 20, 7.0f, this.barSize);
        renderer.drawRegion(this.chrome, this.x, this.y);
        renderer.drawRegion(this.inDanger ? this.dangerSignal : this.safetySignal, this.x + 3, this.y + 2);
    }

    @Override
    public void setValue(float value) {
        this.value = Math.max(0.0f, Math.min(1.0f, value));
        this.barSize = Math.max(0, (int)Math.ceil(this.value * 39.0f));
    }

    @Override
    public float getValue() {
        return this.value;
    }

    @Override
    public Vector3 getPosition() {
        return new Vector3((float)this.x, (float)this.y, 0.0f);
    }

    @Override
    public int getWidth() {
        return 7;
    }

    @Override
    public int getHeight() {
        return 39;
    }
}

