/*
 * Decompiled with CFR 0.152.
 */
package com.me.mygdxgame.entities.particles;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.me.mygdxgame.utilities.EntityState;
import com.me.mygdxgame.utilities.GameEntity;
import com.me.mygdxgame.utilities.Renderer;
import java.util.NoSuchElementException;

public class Splash
implements GameEntity {
    public static final float MIN_INIT_Y_VEL = 50.0f;
    public static final float MAX_INIT_Y_VEL = 150.0f;
    public static final float MIN_INIT_X_VEL = -75.0f;
    public static final float MAX_INIT_X_VEL = 75.0f;
    public static final int DEFAULT_RADIUS = 3;
    private static final float GRAVITY_FACTOR = -400.0f;
    private static final float RADIUS_FALLOFF = 1.5f;
    private static final Color DEFAULT_COLOR = new Color(0.5f, 0.5f, 1.0f, 0.5f);
    private Vector2 position = new Vector2();
    private Vector2 velocity = new Vector2();
    private Rectangle hitbox = new Rectangle(0.0f, 0.0f, 1.0f, 1.0f);
    private Rectangle[] hitAreas = new Rectangle[]{this.hitbox};
    private float lifetime = 5.0f;
    private Color color = DEFAULT_COLOR;

    public Splash(float x, float y) {
        this.position.set(x, y);
        this.velocity.y = (float)(50.0 + Math.random() * 150.0);
        this.velocity.x = (float)(Math.random() * 150.0) + -75.0f;
        this.hitbox.x = x;
        this.hitbox.y = y;
        this.hitbox.width = 3.0f;
        this.hitbox.height = 3.0f;
    }

    public Splash(float x, float y, boolean moveLeft) {
        this.position.set(x, y);
        this.velocity.y = (float)(50.0 + Math.random() * 150.0);
        this.velocity.x = moveLeft ? (float)(Math.random() * 75.0) : (float)(Math.random() * -75.0);
        this.hitbox.x = x;
        this.hitbox.y = y;
        this.hitbox.width = 3.0f;
        this.hitbox.height = 3.0f;
    }

    public Splash(float x, float y, boolean moveLeft, int radius) {
        this.position.set(x, y);
        this.velocity.y = (float)(50.0 + Math.random() * 150.0);
        this.velocity.x = moveLeft ? (float)(Math.random() * 75.0) : (float)(Math.random() * -75.0);
        this.hitbox.x = x;
        this.hitbox.y = y;
        this.hitbox.width = radius;
        this.hitbox.height = radius;
    }

    public Splash(float x, float y, float xVel, float yVel, int radius) {
        this.position.set(x, y);
        this.velocity.set(xVel, yVel);
        this.hitbox.x = x;
        this.hitbox.y = y;
        this.hitbox.width = radius;
        this.hitbox.height = radius;
    }

    public Splash(float x, float y, float xVel, float yVel, int radius, Color color) {
        this.position.set(x, y);
        this.velocity.set(xVel, yVel);
        this.hitbox.x = x;
        this.hitbox.y = y;
        this.hitbox.width = radius;
        this.hitbox.height = radius;
        this.color = color;
    }

    @Override
    public void update(float deltaTime) {
        this.lifetime -= deltaTime;
        this.position.x += this.velocity.x * deltaTime;
        this.position.y += this.velocity.y * deltaTime;
        this.velocity.y += -400.0f * deltaTime;
        this.hitbox.x = this.position.x;
        this.hitbox.y = this.position.y;
        this.hitbox.height = this.hitbox.width = Math.max(this.hitbox.width - 1.5f * deltaTime, 0.0f);
    }

    @Override
    public void draw(Renderer renderer) {
        renderer.drawCircle(ShapeRenderer.ShapeType.Filled, this.color, this.position.x, this.position.y, (int)this.hitbox.width);
    }

    @Override
    public EntityState getState() {
        if (this.lifetime <= 0.0f || this.hitbox.width <= 0.0f) {
            return EntityState.Destroyed;
        }
        return EntityState.Running;
    }

    @Override
    public boolean hasCreatedEntities() {
        return false;
    }

    @Override
    public Rectangle[] getHitArea() {
        return this.hitAreas;
    }

    @Override
    public void destroy() {
        this.lifetime = 0.0f;
    }

    @Override
    public GameEntity[] getCreatedEntities() throws NoSuchElementException {
        throw new NoSuchElementException();
    }

    @Override
    public Vector3 getPosition() {
        return new Vector3(this.position.x, this.position.y, 0.0f);
    }

    @Override
    public int getWidth() {
        return (int)this.hitbox.width;
    }

    @Override
    public int getHeight() {
        return (int)this.hitbox.height;
    }
}

