/*
 * Decompiled with CFR 0.152.
 */
package com.me.mygdxgame.entities;

import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Vector3;
import com.me.mygdxgame.screens.seeteufelscreen.SeeteufelScreen;
import com.me.mygdxgame.utilities.Renderer;
import com.me.mygdxgame.utilities.Updatable;

public class StonePillar
implements Updatable {
    public static final int PILLAR_BASE_X = 224;
    public static final int PILLAR_BASE_Y = 160;
    public static final int PILLAR_BASE_W = 19;
    public static final int PILLAR_BASE_H = 15;
    public static final int PILLAR_W = 32;
    public static final int PILLAR_H = 32;
    public static final int PILLAR_OFFSET_X = 6;
    public static final int PILLAR_OFFSET_Y = -15;
    private Sprite pillar;
    private TextureRegion upperPillarBase;
    private TextureRegion lowerPillarBase;
    private int x;
    private int y;
    private int height;

    public StonePillar(Texture spriteSheet, SeeteufelScreen.MapTiles tiles, int x, int y, int height) {
        this.lowerPillarBase = new TextureRegion(spriteSheet, 224, 160, 19, 15);
        this.upperPillarBase = new TextureRegion(this.lowerPillarBase);
        this.upperPillarBase.flip(false, true);
        this.x = x;
        this.y = y;
        this.height = height;
        float pillarHeight = height - 30;
        this.pillar = new Sprite(tiles.pillarTex);
        this.pillar.setBounds((float)(this.x - 6), (float)(this.y - -15), 32.0f, pillarHeight);
        this.pillar.setV2(pillarHeight / 32.0f);
    }

    @Override
    public void update(float deltaTime) {
    }

    @Override
    public void draw(Renderer renderer) {
        renderer.drawSprite(this.pillar);
        renderer.drawRegion(this.lowerPillarBase, this.x, this.y);
        renderer.drawRegion(this.upperPillarBase, this.x, this.y + this.height - 15);
    }

    public void renderBody(Renderer renderer) {
        renderer.drawSprite(this.pillar);
    }

    public void renderBases(Renderer renderer) {
        renderer.drawRegion(this.lowerPillarBase, this.x, this.y);
        renderer.drawRegion(this.upperPillarBase, this.x, this.y + this.height - 15);
    }

    @Override
    public Vector3 getPosition() {
        return new Vector3((float)this.x, (float)this.y, 0.0f);
    }

    @Override
    public int getWidth() {
        return 19;
    }

    @Override
    public int getHeight() {
        return this.height;
    }
}

